<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sales_payments extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('sales_payments_model','sales');
	}

	public function index()
	{
		$this->permission_check('sales_payment_view');
		$data=$this->data;
		$data['page_title']=$this->lang->line('sales_payments');
		$this->load->view('sales_payments/list',$data);
	}


	public function ajax_list()
	{
		$list = $this->sales->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $sales) {
			
			$no++;
			$row = array();
			
			$row[] = $sales->payment_code;
			$row[] = show_date($sales->payment_date);
			$row[] = get_sales_code($sales->sales_id);
			$row[] = get_customer_details($sales->customer_id)->customer_name;
			// Display payment amount with currency information
			$base_currency = get_base_currency();
			if (!$base_currency) {
				$base_currency = (object)['id' => 1, 'currency_code' => 'USD', 'currency_name' => 'US Dollar'];
			}
			
			$payment_display = store_number_format($sales->payment);
			
			// For old records without currency information, try to get customer's trading currency
			if (empty($sales->payment_currency_id) && !empty($sales->customer_id)) {
				$customer_currency = get_customer_trading_currency($sales->customer_id);
				if ($customer_currency && $customer_currency->id != $base_currency->id) {
					$exchange_rate = get_exchange_rate($base_currency->id, $customer_currency->id);
					if ($exchange_rate != 1.0) {
						$converted_payment = $sales->payment / $exchange_rate;
						$payment_display = '<strong>' . store_number_format($converted_payment) . ' (' . $base_currency->currency_code . ')</strong><br><small class="text-muted">Original: ' . store_number_format($sales->payment) . ' (' . $customer_currency->currency_code . ')</small>';
					} else {
						$payment_display = $payment_display . ' (' . $base_currency->currency_code . ')';
					}
				} else {
					$payment_display = $payment_display . ' (' . $base_currency->currency_code . ')';
				}
			} elseif (!empty($sales->payment_currency_id) && $sales->payment_currency_id != $base_currency->id) {
				$payment_currency = get_currency_by_id($sales->payment_currency_id);
				if ($payment_currency) {
					// Check if we have base_currency_amount stored (new format)
					if (isset($sales->base_currency_amount) && $sales->base_currency_amount > 0) {
						// Use the stored base currency amount
						$converted_payment = $sales->base_currency_amount;
						$conversion_rate = $sales->exchange_rate ?: 1.0;
						$payment_display = '<strong>' . store_number_format($converted_payment) . ' (' . $base_currency->currency_code . ')</strong><br><small class="text-muted">Original: ' . store_number_format($sales->payment) . ' (' . $payment_currency->currency_code . ') | Rate: ' . number_format($conversion_rate, 4) . '</small>';
					} else {
						// Fallback: convert using exchange rate
						$conversion_rate = $sales->exchange_rate ?: 1.0;
						$converted_payment = $sales->payment * $conversion_rate;
						$payment_display = '<strong>' . store_number_format($converted_payment) . ' (' . $base_currency->currency_code . ')</strong><br><small class="text-muted">Original: ' . store_number_format($sales->payment) . ' (' . $payment_currency->currency_code . ') | Rate: ' . number_format($conversion_rate, 4) . '</small>';
					}
				} else {
					$payment_display = $payment_display . ' (' . $base_currency->currency_code . ')';
				}
			} else {
				$payment_display = $payment_display . ' (' . $base_currency->currency_code . ')';
			}
			
			$row[] = $payment_display;


			//$cheque_status = ($sales->cheque_status) ? 'Cleared' : 'Not Cleared';
			$str = (!empty($sales->cheque_number)) ? "<br>Cheque no.:".$sales->cheque_number."<br>Period:".$sales->cheque_period."<br>Status:".
			"<span class='label label-info' style='cursor:pointer'>".$sales->cheque_status."</span>" : '';
			$row[] = ($sales->payment_type).$str;


			$row[] = $sales->payment_note;
			$row[] = ($sales->created_by);

					$str2 = '<div class="btn-group" title="View Account">
										<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
											Action <span class="caret"></span>
										</a>
										<ul role="menu" class="dropdown-menu dropdown-light pull-right">';
											
											if($this->permissions('sales_payment_add') && strtoupper($sales->payment_type)==strtoupper(cheque_name()))
											$str2.='<li>
												<a title="Update Cheque Status" class="pointer" onclick="update_cheque_status('.$sales->id.')" >
													<i class="fa fa-fw fa-hourglass-half text-blue"></i>Update Cheque Status
												</a>
											</li>';



											if($this->permissions('sales_payment_delete'))
											$str2.='<li>
												<a style="cursor:pointer" title="Delete Record ?" onclick="delete_payment(\''.$sales->id.'\')">
													<i class="fa fa-fw fa-trash text-red"></i>Delete
												</a>
											</li>
											
										</ul>
									</div>';			

			$row[] = $str2;

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->sales->count_all(),
						"recordsFiltered" => $this->sales->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
	
	
	/*public function multi_delete(){
		$this->permission_check_with_msg('sales_delete');
		$ids=implode (",",$_POST['checkbox']);
		echo $this->sales->delete_payment($ids);
	}*/


	//Table ajax code
	/*public function search_item(){
		$q=$this->input->get('q');
		$result=$this->sales->search_item($q);
		echo $result;
	}
	public function find_item_details(){
		$id=$this->input->post('id');
		
		$result=$this->sales->find_item_details($id);
		echo $result;
	}*/


	public function delete_payment(){
		$this->permission_check_with_msg('sales_payment_delete');
		$payment_id = $this->input->post('payment_id');
		echo $this->sales->delete_payment($payment_id);
	}
	public function show_cheque_payments_modal(){
		$this->permission_check_with_msg('sales_payment_view');
		$payment_id=$this->input->post('payment_id');
		echo $this->sales->show_cheque_payments_modal($payment_id);
	}
	public function update_cheque_payment(){
		$this->permission_check_with_msg('sales_add');
		echo $this->sales->update_cheque_payment();
	}

	//Print sales Payment Receipt
	/*public function print_show_receipt($payment_id){
		if(!$this->permissions('sales_add') && !$this->permissions('sales_edit')){
			$this->show_access_denied_page();
		}
		$data=$this->data;
		$data['page_title']=$this->lang->line('payment_receipt');
		$data=array_merge($data,array('payment_id'=>$payment_id));
		$this->load->view('print-cust-payment-receipt',$data);
	}*/
	
	
	
}
