<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Services extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('Services_model','services');
	}
	
	
	public function add()
	{
		$this->permission_check('services_add');
		$data=$this->data;
		$data['page_title']=$this->lang->line('services');
		$this->load->view('services/services',$data);
	}

	public function newservices(){
		$this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');
		$this->form_validation->set_rules('category_id', 'Category Name', 'trim|required');
		$this->form_validation->set_rules('price', 'Item Price', 'trim');
		$this->form_validation->set_rules('tax_id', 'Tax', 'trim|required');
		//$this->form_validation->set_rules('purchase_price', 'Purchase Price', 'trim|required'); // Hidden field, calculated automatically
		$this->form_validation->set_rules('sales_price', 'Sales Price', 'trim|required');

		
		if ($this->form_validation->run() == TRUE) {
			// Log the POST data for debugging if needed
			log_message('debug', 'Services POST data: ' . print_r($_POST, TRUE));
			
			// Ensure all price fields are properly set
			$_POST['price'] = floatval($_POST['price']);
			$_POST['sales_price'] = floatval($_POST['sales_price']);
			$_POST['wholesale_price'] = isset($_POST['wholesale_price']) ? floatval($_POST['wholesale_price']) : 0;
			$_POST['retail_price'] = isset($_POST['retail_price']) ? floatval($_POST['retail_price']) : 0;
			
			// If wholesale_price is 0, set it to sales_price
			if ($_POST['wholesale_price'] == 0) {
				$_POST['wholesale_price'] = $_POST['sales_price'];
			}
			
			// If retail_price is 0, set it to sales_price
			if ($_POST['retail_price'] == 0) {
				$_POST['retail_price'] = $_POST['sales_price'];
			}
			
			// Debug: Check if purchase_price is being calculated
			if(empty($_POST['purchase_price'])) {
				// For services, purchase price should be the actual expenses (cost)
				// If expenses (price) is 0, purchase price should also be 0
				$price = $_POST['price']; // Use the actual expenses value
				$tax_id = $_POST['tax_id'];
				$tax_type = $_POST['tax_type'];
				
				// Get tax percentage from database
				$tax_query = $this->db->query("SELECT tax FROM db_tax WHERE id = '$tax_id'");
				$tax_per = 0;
				if($tax_query->num_rows() > 0) {
					$tax_per = $tax_query->row()->tax;
				}
				
				// Calculate purchase price based on actual expenses
				if($price == 0) {
					// If no expenses, purchase price is 0
					$_POST['purchase_price'] = 0;
				} else {
					// If there are expenses, add tax
					if($tax_type == 'Inclusive') {
						$_POST['purchase_price'] = $price;
					} else {
						$_POST['purchase_price'] = $price + ($price * $tax_per / 100);
					}
				}
			}
			
			log_message('debug', 'After processing - price: ' . $_POST['price'] . ', sales_price: ' . $_POST['sales_price'] . ', wholesale_price: ' . $_POST['wholesale_price'] . ', retail_price: ' . $_POST['retail_price'] . ', purchase_price: ' . $_POST['purchase_price']);
			
			$result=$this->services->verify_and_save();
			echo $result;
		} else {
			// Debug: Show validation errors
			$errors = validation_errors();
			echo "Validation Error: " . $errors;
		}
	}
	public function update($id){
		$this->belong_to('db_items',$id);
		$this->permission_check('services_edit');
		$data=$this->data;
		$this->load->model('items_model');
		$result=$this->items_model->get_details($id,$data);
		$data=array_merge($data,$result);
		$data['page_title']=$this->lang->line('services');
		$this->load->view('services/services', $data);
	}
	public function update_services(){
		$this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');
		$this->form_validation->set_rules('category_id', 'Category Name', 'trim|required');
		$this->form_validation->set_rules('price', 'Item Price', 'trim|required');
		$this->form_validation->set_rules('tax_id', 'Tax', 'trim|required');
		//$this->form_validation->set_rules('purchase_price', 'Purchase Price', 'trim|required'); // Hidden field, calculated automatically
		$this->form_validation->set_rules('sales_price', 'Sales Price', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			// Apply the same price logic as in newservices
			$_POST['wholesale_price'] = isset($_POST['wholesale_price']) ? floatval($_POST['wholesale_price']) : 0;
			$_POST['retail_price'] = isset($_POST['retail_price']) ? floatval($_POST['retail_price']) : 0;
			
			// If wholesale_price is 0, set it to sales_price
			if ($_POST['wholesale_price'] == 0) {
				$_POST['wholesale_price'] = floatval($_POST['sales_price']);
			}
			
			// If retail_price is 0, set it to sales_price
			if ($_POST['retail_price'] == 0) {
				$_POST['retail_price'] = floatval($_POST['sales_price']);
			}
			
			$result=$this->services->update_services();
			echo $result;
		} else {
			echo "Please Fill Compulsory(* marked) Fields.";
		}
	}

	public function get_brand_name($brand_id=''){
		if($brand_id==NULL || $brand_id=='' || $brand_id ==0){
			return;
		}
		return $this->db->query('select brand_name from db_brands where id="'.$brand_id.'"')->row()->brand_name;
	}
	
	
	
}
