<?php

function indianCurrency($amount){

	$hasPaisa=false;
    $arr=explode(".",$amount);
    $rupees=$arr[0];
    if(isset($arr[1])&&((int)$arr[1])>0){
      if(strlen($arr[1])>2){
        $arr[1]=substr($arr[1],0,2);
      }
      $hasPaisa=true;
      $paisa=$arr[1];
    }

    $w="";
    $crore=(int)($rupees/10000000);
    $rupees=$rupees%10000000;
    $w.=single_word($crore,"Cror ");
    $lakh=(int)($rupees/100000);
    $rupees=$rupees%100000;
    $w.=single_word($lakh,"Lakh ");
    $thousand=(int)($rupees/1000);
    $rupees=$rupees%1000;
    $w.=single_word($thousand,"Thousand  ");
    $hundred=(int)($rupees/100);
    $w.=single_word($hundred,"Hundred ");
    $ten=$rupees%100;
    $w.=single_word($ten,"");
    $w.="Rupees ";

    if($hasPaisa){
      if($paisa[0]=="0"){
        $paisa=(int)$paisa;
      }
      else if(strlen($paisa)==1){
        $paisa=$paisa*10;
      }
      $w.=" and ".single_word($paisa," Paisa");
    }
    return $w." Only";
  }

 function single_word($n,$txt){
    $t="";
    if($n<=19){
      $t=words_array($n);
    }else{
      $a=$n-($n%10);
      $b=$n%10;
      $t=words_array($a)." ".words_array($b);
    }
    if($n==0){
      $txt="";
    }
    return $t." ".$txt;
  }

   function words_array($num){
    $n=[0=>"", 1=>"One", 2=>"Two", 3=>"Three", 4=>"Four", 5=>"Five", 6=>"Six", 7=>"Seven", 8=>"Eight", 9=>"Nine", 10=>"Ten", 11=>"Eleven", 12=>"Twelve", 13=>"Thirteen", 14=>"Fourteen", 15=>"Fifteen", 16=>"Sixteen", 17=>"Seventeen", 18=>"Eighteen", 19=>"Nineteen", 20=>"Twenty", 30=>"Thirty", 40=>"Forty", 50=>"Fifty", 60=>"Sixty", 70=>"Seventy", 80=>"Eighty", 90=>"Ninety", 100=>"Hundred",];
    return $n[$num];
  }

  /**
   * Check if exchange rate exists between two currencies
   * @param int $from_currency_id
   * @param int $to_currency_id
   * @param string $date (optional, defaults to today)
   * @return array
   */
  function check_exchange_rate_exists($from_currency_id, $to_currency_id, $date = null) {
    $CI =& get_instance();
    
    if ($date === null) {
      $date = date('Y-m-d');
    }
    
    error_log("check_exchange_rate_exists called with from_currency_id: $from_currency_id, to_currency_id: $to_currency_id, date: $date");
    
    // If same currency, no exchange rate needed
    if ($from_currency_id == $to_currency_id) {
      return array(
        'exists' => true,
        'rate' => 1.0,
        'message' => 'Same currency - no exchange rate needed'
      );
    }
    
    // Check for exchange rate from currency A to currency B
    $rate_ab = $CI->db->query("
      SELECT * FROM db_exchange_rates 
      WHERE from_currency_id = ? 
        AND to_currency_id = ? 
        AND effective_date <= ? 
        AND (expiry_date IS NULL OR expiry_date >= ?) 
        AND status = 1 
      ORDER BY effective_date DESC 
      LIMIT 1
    ", array($from_currency_id, $to_currency_id, $date, $date))->row();
    
    // Check for reverse exchange rate (currency B to currency A)
    $rate_ba = $CI->db->query("
      SELECT * FROM db_exchange_rates 
      WHERE from_currency_id = ? 
        AND to_currency_id = ? 
        AND effective_date <= ? 
        AND (expiry_date IS NULL OR expiry_date >= ?) 
        AND status = 1 
      ORDER BY effective_date DESC 
      LIMIT 1
    ", array($to_currency_id, $from_currency_id, $date, $date))->row();
    
    error_log("Rate AB result: " . ($rate_ab ? json_encode($rate_ab) : 'null'));
    error_log("Rate BA result: " . ($rate_ba ? json_encode($rate_ba) : 'null'));
    
    if ($rate_ab) {
      return array(
        'exists' => true,
        'rate' => $rate_ab->exchange_rate,
        'message' => 'Exchange rate found'
      );
    } elseif ($rate_ba) {
      // Calculate reverse rate
      $reverse_rate = 1 / $rate_ba->exchange_rate;
      return array(
        'exists' => true,
        'rate' => $reverse_rate,
        'message' => 'Reverse exchange rate found'
      );
    } else {
      // Get currency names for error message
      $from_currency = $CI->db->where('id', $from_currency_id)->get('db_currency')->row();
      $to_currency = $CI->db->where('id', $to_currency_id)->get('db_currency')->row();
      
      $from_name = $from_currency ? $from_currency->currency_code : 'Unknown';
      $to_name = $to_currency ? $to_currency->currency_code : 'Unknown';
      
      return array(
        'exists' => false,
        'rate' => 0,
        'message' => "No exchange rate found between {$from_name} and {$to_name}. Please add exchange rate first.",
        'from_currency' => $from_name,
        'to_currency' => $to_name
      );
    }
  }


