<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_create_system_settings_table extends CI_Migration {

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'setting_key' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => FALSE
            ),
            'setting_value' => array(
                'type' => 'TEXT',
                'null' => TRUE
            ),
            'setting_type' => array(
                'type' => 'ENUM',
                'constraint' => ['string', 'integer', 'boolean', 'json'],
                'default' => 'string'
            ),
            'description' => array(
                'type' => 'TEXT',
                'null' => TRUE
            ),
            'is_public' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0
            ),
            'created_at' => array(
                'type' => 'TIMESTAMP',
                'null' => TRUE,
                'default' => 'CURRENT_TIMESTAMP'
            ),
            'updated_at' => array(
                'type' => 'TIMESTAMP',
                'null' => TRUE,
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            )
        ));
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('setting_key', TRUE);
        $this->dbforge->create_table('db_system_settings');
        
        // Insert default settings
        $default_settings = [
            [
                'setting_key' => 'maintenance_mode',
                'setting_value' => '0',
                'setting_type' => 'boolean',
                'description' => 'Enable/disable maintenance mode',
                'is_public' => 0
            ],
            [
                'setting_key' => 'backup_retention_days',
                'setting_value' => '30',
                'setting_type' => 'integer',
                'description' => 'Number of days to retain backups',
                'is_public' => 0
            ],
            [
                'setting_key' => 'email_notifications',
                'setting_value' => '1',
                'setting_type' => 'boolean',
                'description' => 'Enable email notifications',
                'is_public' => 0
            ]
        ];
        
        foreach($default_settings as $setting) {
            $this->db->insert('db_system_settings', $setting);
        }
    }

    public function down()
    {
        $this->dbforge->drop_table('db_system_settings');
    }
}

