<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_add_dual_mode_settings extends CI_Migration {

    public function up()
    {
        // Add dual mode settings to the existing system settings table
        $dual_mode_settings = [
            [
                'setting_key' => 'database_mode',
                'setting_value' => 'offline',
                'setting_type' => 'string',
                'description' => 'Current database mode: offline or online',
                'is_public' => 0
            ],
            [
                'setting_key' => 'installation_mode',
                'setting_value' => 'single',
                'setting_type' => 'string',
                'description' => 'Installation mode: single or dual',
                'is_public' => 0
            ],
            [
                'setting_key' => 'offline_database_config',
                'setting_value' => '{}',
                'setting_type' => 'json',
                'description' => 'Offline database configuration',
                'is_public' => 0
            ],
            [
                'setting_key' => 'online_database_config',
                'setting_value' => '{}',
                'setting_type' => 'json',
                'description' => 'Online database configuration',
                'is_public' => 0
            ],
            [
                'setting_key' => 'offline_url',
                'setting_value' => '',
                'setting_type' => 'string',
                'description' => 'Offline site URL',
                'is_public' => 0
            ],
            [
                'setting_key' => 'online_url',
                'setting_value' => '',
                'setting_type' => 'string',
                'description' => 'Online site URL',
                'is_public' => 0
            ],
            [
                'setting_key' => 'mode_switch_count',
                'setting_value' => '0',
                'setting_type' => 'integer',
                'description' => 'Number of times mode has been switched',
                'is_public' => 0
            ],
            [
                'setting_key' => 'last_mode_switch',
                'setting_value' => null,
                'setting_type' => 'string',
                'description' => 'Last mode switch timestamp',
                'is_public' => 0
            ],
            [
                'setting_key' => 'sync_enabled',
                'setting_value' => '0',
                'setting_type' => 'boolean',
                'description' => 'Enable data synchronization between modes',
                'is_public' => 0
            ],
            [
                'setting_key' => 'last_sync_time',
                'setting_value' => null,
                'setting_type' => 'string',
                'description' => 'Last synchronization timestamp',
                'is_public' => 0
            ],
            [
                'setting_key' => 'sync_frequency',
                'setting_value' => '300',
                'setting_type' => 'integer',
                'description' => 'Synchronization frequency in seconds (default: 5 minutes)',
                'is_public' => 0
            ],
            [
                'setting_key' => 'auto_sync_on_online',
                'setting_value' => '1',
                'setting_type' => 'boolean',
                'description' => 'Automatically sync when switching to online mode',
                'is_public' => 0
            ]
        ];
        
        foreach($dual_mode_settings as $setting) {
            // Check if setting already exists
            $existing = $this->db->where('setting_key', $setting['setting_key'])->get('db_system_settings')->row();
            if (!$existing) {
                $this->db->insert('db_system_settings', $setting);
            }
        }
    }

    public function down()
    {
        // Remove dual mode settings
        $setting_keys = [
            'database_mode',
            'installation_mode',
            'offline_database_config',
            'online_database_config',
            'offline_url',
            'online_url',
            'mode_switch_count',
            'last_mode_switch',
            'sync_enabled',
            'last_sync_time',
            'sync_frequency',
            'auto_sync_on_online'
        ];
        
        foreach($setting_keys as $key) {
            $this->db->where('setting_key', $key)->delete('db_system_settings');
        }
    }
}
