<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_add_show_logo_on_pos_invoice extends CI_Migration {

    public function up()
    {
        // Add show_logo_on_pos_invoice column to db_store table
        $fields = array(
            'show_logo_on_pos_invoice' => array(
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'null' => TRUE,
                'comment' => '1=Show logo on POS invoice, 0=Hide logo'
            )
        );
        
        if (!$this->db->field_exists('show_logo_on_pos_invoice', 'db_store')) {
            $this->dbforge->add_column('db_store', $fields);
        }
    }

    public function down()
    {
        // Remove the column if it exists
        if ($this->db->field_exists('show_logo_on_pos_invoice', 'db_store')) {
            $this->dbforge->drop_column('db_store', 'show_logo_on_pos_invoice');
        }
    }
}
