<!DOCTYPE html>
<html>

<head>
<!-- TABLES CSS CODE -->
<?php $this->load->view('comman/code_css.php');?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <?php
  if(isset($account_id)){
      $q2 = $this->db->query("select a.*, c.currency_name, c.currency_code, c.symbol from ac_accounts a left join db_currency c on a.currency_id = c.id where a.id=$account_id");
      $account_code=$q2->row()->account_code;
      $created_date=show_date($q2->row()->created_date);
      $account_name=$q2->row()->account_name;
      $account_balance_amount=$q2->row()->balance;
      $base_balance_amount=$q2->row()->base_currency_balance;
      $account_currency_id=$q2->row()->currency_id ?: get_base_currency()->id;
      $currency_name=$q2->row()->currency_name ?: 'Base Currency';
      $currency_code=$q2->row()->currency_code ?: get_base_currency()->currency_code;
      $currency_symbol=$q2->row()->symbol ?: get_base_currency()->symbol;
      
      // Format balance with account currency first and system currency in parentheses
      $base_currency = get_base_currency();
      if ($account_currency_id == $base_currency->id) {
          // Same currency, just show the amount
          $balance = format_currency_amount($account_balance_amount, $account_currency_id);
      } else {
          // Different currencies, show account currency with base currency in parentheses
          $account_display = format_currency_amount($account_balance_amount, $account_currency_id);
          
          // Use stored base currency balance if available, otherwise calculate it
          $base_amount = $base_balance_amount;
          if (empty($base_amount) || $base_amount == 0) {
              $base_amount = convert_currency($account_balance_amount, $account_currency_id, $base_currency->id);
          }
          $base_display = format_currency_amount($base_amount, $base_currency->id);
          $balance = $account_display . ' ( ' . $base_display . ' )';
      }
    }
  ?>

  <!-- Left side column. contains the logo and sidebar -->
  
  <?php $this->load->view('sidebar');?>
  <?php $CI =& get_instance(); ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <?= $this->lang->line('account_book'); ?>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><?= $this->lang->line('accounts_list'); ?></li>
      </ol>
    </section>

    <!-- Main content -->
    <?= form_open('#', array('class' => '', 'id' => 'table_form')); ?>
    <input type="hidden" id='base_url' value="<?=$base_url;?>">
    <section class="content">
      <div class="row">
        <!-- ********** ALERT MESSAGE START******* -->
          <?php $this->load->view('comman/code_flashdata');?>
            <!-- ********** ALERT MESSAGE END******* -->
        <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="accounts-form" >
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="row">
                                 <div class="col-md-5">
                                    <div class="form-group">
                                       <label for="account_code" class="col-sm-5 control-label text-right"><?= $this->lang->line('account_code'); ?> :</label>
                                       <div class="col-sm-7">
                                          <label for="account_code" class=" control-label text-right"><?=$account_code?></label>
                                       </div>
                                    </div>
                                    <div class="form-group">
                                       <label for="account_name" class="col-sm-5 control-label text-right"><?= $this->lang->line('account_name'); ?> :</label>
                                       <div class="col-sm-7">
                                          <label for="account_name" class=" control-label text-right"><?=$account_name?></label>
                                       </div>
                                    </div>
                                    <!-- ########### -->
                                 </div>
                                 <div class="col-md-5">
                                    <div class="form-group">
                                       <label for="balance" class="col-sm-5 control-label text-right"><?= $this->lang->line('balance'); ?> :</label>
                                       <div class="col-sm-7">
                                          <label for="balance" class=" control-label text-right"><?=$balance?></label>
                                       </div>                                    
                                    </div>
                                    <div class="form-group">
                                       <label for="currency" class="col-sm-5 control-label text-right">Currency :</label>
                                       <div class="col-sm-7">
                                          <label for="currency" class=" control-label text-right"><?=$currency_name?> (<?=$currency_code?>)</label>
                                       </div>                                    
                                    </div>
                                    <div class="form-group">
                                       <label for="balance" class="col-sm-5 control-label text-right"><?= $this->lang->line('created_date'); ?> :</label>
                                       <div class="col-sm-7">
                                          <label for="balance" class=" control-label text-right"><?=$created_date?></label>
                                       </div>                                    
                                    </div>
                                 </div>
                                 <!-- ########### -->
                              </div>
                           </div>
                           <!-- /.box-body -->
                           
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>

        <div class="col-xs-12">
          <div class="box box-primary">
            <div class="box-header ">
              <h3 class="box-title"><?= $this->lang->line('transactions_list'); ?></h3>
              <div class="row">

                <div class="col-md-12">
                  
                
                
                  <div class="col-md-3">
                    <div class="form-group">
                       <label for="from_date"><?= $this->lang->line('from_date'); ?> </label></label>
                       <div class="input-group date">
                         <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                         </div>
                         <input type="text" class="form-control pull-right datepicker"  id="from_date" name="from_date">
                      </div>
                       <span id="transfer_date_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                       <label for="to_date"><?= $this->lang->line('to_date'); ?> </label></label>
                       <div class="input-group date">
                         <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                         </div>
                         <input type="text" class="form-control pull-right datepicker"  id="to_date" name="to_date">
                      </div>
                       <span id="transfer_date_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>

                  

                  <div class="col-md-3 hide">
                    <div class="form-group">
                       <label for="users"><?= $this->lang->line('users'); ?> </label></label>
                       <select class="form-control select2" id="users" name="users"  style="width: 100%;">
                        <?= get_users_select_list($this->session->userdata("role_id"),get_current_store_id()); ?>
                     </select>
                       <span id="users_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                  
                </div>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example2" class="table table-bordered custom_hover" width="100%">
                <thead class="bg-gray ">
                <tr>
                  <th><?= $this->lang->line('date'); ?></th>
                  <th><?= $this->lang->line('description'); ?></th>
                  <!-- <th><?= $this->lang->line('debit_account'); ?></th>
                  <th><?= $this->lang->line('credit_account'); ?></th>  -->
                  <th>Amount Out</th>
                  <th>Amount In</th>
                  <th><?= $this->lang->line('balance'); ?></th>
                  <th><?= $this->lang->line('note'); ?></th>
                  <th><?= $this->lang->line('created_by'); ?></th>
                  <th><?= $this->lang->line('action'); ?></th>
                </tr>
                </thead>
                <tbody>
				
                </tbody>
               
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
    <?= form_close();?>
  </div>
  <!-- /.content-wrapper -->
  <?php $this->load->view('footer.php');?>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
      <?php $this->load->view('comman/code_js_sound.php');?>
      <!-- TABLES CODE -->
      <?php $this->load->view('comman/code_js.php');?>

<script type="text/javascript">
function load_datatable(){
    //datatables
   var table = $('#example2').DataTable({ 

      /* CUSTOM BUTTONS START*/
  dom:'<"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr><"pull-right margin-left-10 custom-buttons">>>tip',
 
      buttons: {
        buttons: [
            {
                className: 'btn bg-red color-palette btn-flat hidden delete_btn pull-left',
                text: 'Delete',
                action: function ( e, dt, node, config ) {
                    multi_delete();
                }
            }
            ]
        },
        /* CUSTOM BUTTONS END */

        "processing": true, //Feature control the processing indicator.
        "serverSide": true, //Feature control DataTables' server-side processing mode.
        "order": [], //Initial no order.
        "responsive": true,
        "searching": false,
        language: {
            processing: '<div class="text-primary bg-primary" style="position: relative;z-index:100;overflow: visible;">Processing...</div>'
        },
        // Load data for the table's content from an Ajax source
        "ajax": {
            "url": "<?php echo site_url('account_transactions/ajax_list')?>",
            "type": "POST",
            "data": {
                      account_id : '<?=$account_id?>',
                       from_date: $("#from_date").val(),
                       to_date: $("#to_date").val(),
                       users: $("#users").val(),
                    },
            complete: function (data) {
             $('.column_checkbox').iCheck({
                checkboxClass: 'icheckbox_square-orange',
                /*uncheckedClass: 'bg-white',*/
                radioClass: 'iradio_square-orange',
                increaseArea: '10%' // optional
              });
             call_code();
              //$(".delete_btn").hide();
             },

        },

        //Set column definition initialisation properties.
        "columnDefs": [
        { 
            "targets": [ 0,1,2,3,4 ], //first column / numbering column
            "orderable": false, //set not orderable
            
        },
        {
            "targets" :[0],
            "className": "text-center",
        },
        {
            "targets" :[2,3,4],
            "className": "text-right",
        },
        
        ],
    });
    new $.fn.dataTable.FixedHeader( table );
    
    // Add custom buttons
    addCustomButtons();
}

function addCustomButtons() {
    // Remove existing custom buttons if any
    $('.custom-buttons').remove();
    
    // Create custom button container
    var buttonContainer = $('<div class="custom-buttons"></div>');
    
    // Add Print Statement button only
    var printStatementBtn = $('<a href="<?php echo base_url('accounts/statement/'.$account_id); ?>" target="_blank" class="btn btn-success btn-sm custom-btn">' +
        '<i class="fa fa-file-text"></i> Print Statement' +
        '</a>');
    
    // Append button to container
    buttonContainer.append(printStatementBtn);
    
    // Insert button container in the top right of the transactions list (where arrow points)
    if ($('.box-header').length > 0) {
        $('.box-header').append(buttonContainer);
    } else {
        // Fallback: insert after the table wrapper
        $('.dataTables_wrapper').append(buttonContainer);
    }
}

$(document).ready(function() {
    load_datatable();
});
$("#from_date,#to_date,#users").on("change",function(){
      $('#example2').DataTable().destroy();
      load_datatable();
  });

// Re-add buttons when table is redrawn
$(document).on('draw.dt', '#example2', function() {
    addCustomButtons();
});

// No export functions needed - only Print Statement button
</script>

<style>
.custom-buttons {
    display: inline-block;
    float: right;
    margin-top: 5px;
}

.custom-btn {
    margin-right: 5px;
    margin-bottom: 5px;
    border-radius: 4px;
    font-weight: 500;
    transition: all 0.3s ease;
    display: inline-block;
}

.custom-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

.custom-btn i {
    margin-right: 5px;
}

/* Print Statement button styling */
.btn-success.custom-btn {
    background: #28a745;
    border-color: #28a745;
    color: white;
}

/* Ensure box header can contain the button */
.box-header {
    position: relative;
    overflow: visible;
}

.box-header h3 {
    display: inline-block;
    margin: 0;
}

/* Responsive design */
@media (max-width: 768px) {
    .custom-buttons {
        margin-left: 0;
        margin-top: 10px;
        text-align: center;
        float: none;
    }
    
    .custom-btn {
        margin-right: 3px;
        margin-bottom: 3px;
        font-size: 12px;
        padding: 4px 8px;
    }
}
</style>

<script>
  //Delete Record start
function delete_transaction(q_id,entry_of)
{   
    var base_url = $("#base_url").val();
    //entry_of=(entry_of==1) ? 'transfer' : 'deposit';

   if(confirm("Are you Sure ?\nIt will Delete Real Payments entry as well!!")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
   $.post(base_url+"account_transactions/delete_transaction",{q_id:q_id,entry_of:entry_of},function(result){
   result=result;
     if(result=="success")
        {
          toastr["success"]("Record Deleted Successfully!");
          success.currentTime = 0; 
          success.play();
          $('#example2').DataTable().ajax.reload();
        }
        else if(result=="failed"){
          toastr["error"]("Failed to Delete .Try again!");
          failed.currentTime = 0; 
          failed.play();
        }
        else{
          toastr["error"](result);
          failed.currentTime = 0; 
          failed.play();
        }
        $(".overlay").remove();
        return false;
   });
   }//end confirmation
}
</script>
<!-- Make sidebar menu hughlighter/selector -->
<script>$(".accounts_list-active-li").addClass("active");</script>		
</body>
</html>
