<!DOCTYPE html>
<html>
<head>
    <!-- TABLES CSS CODE -->
    <?php $this->load->view('comman/code_css.php');?>
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php $this->load->view('sidebar');?>
        
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Multi-Currency Accounts Summary
                    <small>Overview of accounts by currency</small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php echo $base_url; ?>accounts">Accounts</a></li>
                    <li class="active">Currency Summary</li>
                </ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <!-- ********** ALERT MESSAGE START******* -->
                    <?php $this->load->view('comman/code_flashdata');?>
                    <!-- ********** ALERT MESSAGE END******* -->
                    
                    <div class="col-xs-12">
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title">
                                    <i class="fa fa-exchange"></i> Currency-wise Account Summary
                                </h3>
                                <div class="box-tools pull-right">
                                    <button type="button" class="btn btn-box-tool" data-widget="refresh" onclick="loadCurrencySummary()">
                                        <i class="fa fa-refresh"></i>
                                    </button>
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <div id="loading" class="text-center" style="padding: 20px;">
                                    <i class="fa fa-spinner fa-spin"></i> Loading currency summary...
                                </div>
                                
                                <div id="currency-summary-content" style="display: none;">
                                    <!-- Currency summary will be loaded here -->
                                </div>
                            </div>
                            <!-- /.box-body -->
                        </div>
                        <!-- /.box -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->
        
        <?php $this->load->view('footer.php');?>
        
        <!-- Add the sidebar's background. This div must be placed immediately after the control sidebar -->
        <div class="control-sidebar-bg"></div>
    </div>
    <!-- ./wrapper -->

    <!-- SOUND CODE -->
    <?php $this->load->view('comman/code_js_sound.php');?>
    <!-- TABLES CODE -->
    <?php $this->load->view('comman/code_js.php');?>

    <script type="text/javascript">
        $(document).ready(function() {
            loadCurrencySummary();
        });
        
        function loadCurrencySummary() {
            $('#loading').show();
            $('#currency-summary-content').hide();
            
            $.post('<?php echo $base_url; ?>accounts/get_currency_summary', function(result) {
                $('#loading').hide();
                
                if (result.success) {
                    displayCurrencySummary(result.currencies);
                } else {
                    $('#currency-summary-content').html(
                        '<div class="alert alert-danger">Error loading currency summary: ' + result.message + '</div>'
                    ).show();
                }
            }, 'json').fail(function() {
                $('#loading').hide();
                $('#currency-summary-content').html(
                    '<div class="alert alert-danger">Failed to load currency summary. Please try again.</div>'
                ).show();
            });
        }
        
        function displayCurrencySummary(currencies) {
            var html = '<div class="row">';
            
            currencies.forEach(function(currency) {
                var isBaseCurrency = currency.currency_code === '<?= get_base_currency()->currency_code; ?>';
                var cardClass = isBaseCurrency ? 'box-success' : 'box-info';
                var badgeClass = isBaseCurrency ? 'bg-green' : 'bg-blue';
                
                html += '<div class="col-md-4">';
                html += '<div class="box ' + cardClass + '">';
                html += '<div class="box-header with-border">';
                html += '<h3 class="box-title">';
                html += '<i class="fa fa-money"></i> ' + currency.currency_name;
                if (isBaseCurrency) {
                    html += ' <span class="badge bg-green">Base Currency</span>';
                }
                html += '</h3>';
                html += '</div>';
                html += '<div class="box-body">';
                html += '<div class="row">';
                html += '<div class="col-md-6">';
                html += '<strong>Currency Code:</strong><br>';
                html += '<span class="text-lg">' + currency.currency_code + '</span>';
                html += '</div>';
                html += '<div class="col-md-6">';
                html += '<strong>Symbol:</strong><br>';
                html += '<span class="text-lg">' + currency.symbol + '</span>';
                html += '</div>';
                html += '</div>';
                html += '<hr>';
                html += '<div class="row">';
                html += '<div class="col-md-6">';
                html += '<strong>Total Accounts:</strong><br>';
                html += '<span class="text-lg text-primary">' + currency.account_count + '</span>';
                html += '</div>';
                html += '<div class="col-md-6">';
                html += '<strong>Total Balance:</strong><br>';
                html += '<span class="text-lg text-success">' + currency.symbol + ' ' + parseFloat(currency.total_balance).toFixed(2) + '</span>';
                html += '</div>';
                html += '</div>';
                
                if (!isBaseCurrency && currency.total_base_balance > 0) {
                    html += '<hr>';
                    html += '<div class="row">';
                    html += '<div class="col-md-12">';
                    html += '<strong>Base Currency Equivalent:</strong><br>';
                    html += '<span class="text-lg text-info"><?= get_base_currency()->symbol; ?> ' + parseFloat(currency.total_base_balance).toFixed(2) + '</span>';
                    html += '</div>';
                    html += '</div>';
                }
                
                html += '</div>';
                html += '<div class="box-footer">';
                html += '<a href="<?php echo $base_url; ?>accounts?currency=' + currency.id + '" class="btn btn-sm btn-primary">';
                html += '<i class="fa fa-eye"></i> View Accounts';
                html += '</a>';
                html += '</div>';
                html += '</div>';
                html += '</div>';
            });
            
            html += '</div>';
            
            $('#currency-summary-content').html(html).show();
        }
    </script>
    
    <!-- Make sidebar menu highlighter/selector -->
    <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
</body>
</html>
