<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Deposit Receipt - <?php echo $company_name; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/bower_components/Ionicons/css/ionicons.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/dist/css/skins/_all-skins.min.css">
    
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        
        .receipt-container {
            max-width: 700px;
            margin: 0 auto;
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .receipt-header {
            background: #ffffff;
            color: #000000;
            padding: 20px;
            text-align: center;
            border-bottom: 2px solid #28a745;
        }
        .company-header {
            margin-top: 10px;
            font-size: 12px;
            line-height: 1.4;
            font-weight: bold;
            color: #000000;
        }
        
        .receipt-title {
            font-size: 24px;
            font-weight: bold;
            margin: 0 0 5px 0;
        }
        
        .receipt-subtitle {
            font-size: 14px;
            opacity: 0.9;
            margin: 0;
        }
        
        .receipt-number {
            background: rgba(255,255,255,0.2);
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
            margin-top: 10px;
            font-weight: bold;
        }
        
        .receipt-body {
            padding: 30px;
        }
        
        .success-bar {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 25px;
            text-align: center;
            font-weight: bold;
        }
        
        .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin: 20px 0 10px 0;
            padding-bottom: 5px;
            border-bottom: 2px solid #28a745;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dotted #ddd;
        }
        
        .info-label {
            font-weight: bold;
            color: #666;
            min-width: 150px;
        }
        
        .info-value {
            color: #333;
            text-align: right;
        }
        
        .amount-section {
            background: #f8f9fa;
            border: 2px solid #28a745;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            margin: 20px 0;
        }
        
        .amount-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .amount-value {
            font-size: 28px;
            font-weight: bold;
            color: #28a745;
        }
        
        .account-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 20px 0;
        }
        
        .account-box {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
        }
        
        .account-title {
            font-weight: bold;
            color: #28a745;
            margin-bottom: 10px;
            font-size: 14px;
        }
        
        .account-name {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }
        
        .account-code {
            font-size: 12px;
            color: #666;
            font-family: monospace;
        }
        
        .account-balance {
            font-size: 12px;
            color: #28a745;
            margin-top: 5px;
        }
        
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #ddd;
        }
        
        .company-info {
            font-size: 12px;
            color: #666;
            line-height: 1.4;
        }
        
        .signature-section {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
        }
        
        .signature-line {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
        }
        
        .signature-box {
            text-align: center;
            width: 200px;
        }
        
        .signature-line-dash {
            border-bottom: 1px solid #333;
            height: 1px;
            margin-bottom: 5px;
        }
        
        .action-buttons {
            text-align: center;
            margin: 30px 0;
        }
        
        .btn-print {
            background: #28a745;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 5px;
            margin: 0 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
        }
        
        .btn-print:hover {
            background: #218838;
        }
        
        .btn-download {
            background: #007bff;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 5px;
            margin: 0 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
        }
        
        .btn-download:hover {
            background: #0056b3;
        }
        
        /* Print Styles */
        @media print {
            body {
                background: white;
                margin: 0;
                padding: 0;
            }
            
            .receipt-container {
                max-width: none;
                box-shadow: none;
                border-radius: 0;
            }
            
            .action-buttons {
                display: none;
            }
            
            .receipt-header {
                background: #ffffff !important;
                color: #000000 !important;
                border-bottom: 3px solid #000000 !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .receipt-title {
                color: #000000 !important;
                font-weight: 900 !important;
                font-size: 28px !important;
                text-shadow: none !important;
            }
            
            .company-header {
                color: #000000 !important;
                font-weight: 900 !important;
                font-size: 14px !important;
                text-shadow: none !important;
            }
            
            .receipt-number {
                color: #000000 !important;
                font-weight: 900 !important;
                background: #f0f0f0 !important;
                border: 2px solid #000000 !important;
                padding: 8px 16px !important;
            }
            
            .receipt-body {
                padding: 20px;
            }
            
            .amount-value {
                font-size: 24px;
            }
            
            .info-row {
                font-size: 12px;
            }
            
            .account-details {
                gap: 15px;
            }
            
            .account-box {
                padding: 10px;
            }
            
            .account-name {
                font-size: 14px;
            }
            
            .account-code {
                font-size: 11px;
            }
            
            .footer {
                font-size: 11px;
            }
        }
        
        /* 80mm Receipt Styles (triggered via .print-80mm class) */
        body.print-80mm .receipt-container {
            max-width: 80mm;
            width: 80mm;
            margin: 0 auto;
            box-shadow: none;
            border-radius: 0;
        }
        body.print-80mm .receipt-header { padding: 10px 8px; }
        body.print-80mm .receipt-title { font-size: 18px; }
        body.print-80mm .receipt-subtitle { font-size: 12px; }
        body.print-80mm .company-header { font-size: 11px; }
        body.print-80mm .receipt-body { padding: 10px; }
        body.print-80mm .amount-section { padding: 10px; margin: 12px 0; }
        body.print-80mm .amount-value { font-size: 18px; }
        body.print-80mm .section-title { font-size: 13px; margin: 12px 0 6px 0; }
        body.print-80mm .info-row { font-size: 11px; padding: 6px 0; }
        body.print-80mm .account-details { display: block; }
        body.print-80mm .account-box { margin-bottom: 8px; }
        body.print-80mm .footer { padding: 10px; font-size: 10px; }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="receipt-header">
            <div class="receipt-title">DEPOSIT RECEIPT</div>
            <div class="company-header">
                <strong><?php echo $company_name; ?></strong>
                <?php if($company_address): ?><br><?php echo $company_address; ?><?php endif; ?>
                <?php if($company_city || $company_state): ?><br><?php echo $company_city; ?><?php if($company_state): ?>, <?php echo $company_state; ?><?php endif; ?><?php endif; ?>
                <?php if($company_phone): ?><br>Phone: <?php echo $company_phone; ?><?php endif; ?>
                <?php if($company_website): ?><br><?php echo $company_website; ?><?php endif; ?>
            </div>
            <div class="receipt-number">Receipt #<?php echo str_pad($deposit->id, 6, '0', STR_PAD_LEFT); ?></div>
        </div>
        
        <!-- Body -->
        <div class="receipt-body">
            <!-- Success Message -->
            <div class="success-bar">
                <i class="fa fa-check-circle"></i> Deposit Transaction Completed Successfully
            </div>
            
            <!-- Transaction Details -->
            <div class="section-title">
                <i class="fa fa-info-circle"></i> Transaction Details
            </div>
            <div class="info-row">
                <span class="info-label">Transaction Date:</span>
                <span class="info-value"><?php echo date('M d, Y', strtotime($deposit_date)); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Reference Number:</span>
                <span class="info-value"><?php echo $reference_no ?: 'N/A'; ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Transaction ID:</span>
                <span class="info-value"><?php echo str_pad($deposit->id, 6, '0', STR_PAD_LEFT); ?></span>
            </div>
            
            <!-- Amount Section -->
            <div class="amount-section">
                <div class="amount-label">Amount Deposited</div>
                <div class="amount-value"><?php echo $deposit_currency_symbol . ' ' . number_format($amount, 2); ?></div>
                <div style="font-size: 12px; color: #666; margin-top: 5px;">
                    Currency: <?php echo $deposit_currency->currency_name . ' (' . $deposit_currency->currency_code . ')'; ?>
                </div>
            </div>
            
            <!-- Account Information -->
            <div class="section-title">
                <i class="fa fa-university"></i> Deposit Information
            </div>
            <div class="account-details">
                <?php if($from_account): ?>
                <div class="account-box">
                    <div class="account-title">
                        <i class="fa fa-arrow-down text-info"></i> Source Account
                    </div>
                    <div class="account-name"><?php echo $from_account->account_name; ?></div>
                    <div class="account-code">Code: <?php echo $from_account->account_code; ?></div>
                </div>
                <?php endif; ?>
                <div class="account-box">
                    <div class="account-title">
                        <i class="fa fa-plus-circle text-success"></i> Deposit To Account
                    </div>
                    <div class="account-name"><?php echo $to_account->account_name; ?></div>
                    <div class="account-code">Code: <?php echo $to_account->account_code; ?></div>
                </div>
            </div>
            
            <!-- Additional Information -->
            <?php if($note): ?>
            <div class="section-title">
                <i class="fa fa-sticky-note"></i> Additional Information
            </div>
            <div class="info-row">
                <span class="info-label">Notes:</span>
                <span class="info-value"><?php echo $note; ?></span>
            </div>
            <?php endif; ?>
            
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <div class="company-info">
                <strong><?php echo $company_name; ?></strong><br>
                <?php if($company_address): ?><?php echo $company_address; ?><br><?php endif; ?>
                <?php if($company_city): ?><?php echo $company_city; ?><?php endif; ?>
                <?php if($company_state): ?>, <?php echo $company_state; ?><?php endif; ?><br>
                <?php if($company_phone): ?>Phone: <?php echo $company_phone; ?><br><?php endif; ?>
                <?php if($company_website): ?>Website: <?php echo $company_website; ?><br><?php endif; ?>
                <br>
                <small>This is a computer generated receipt. No signature required.</small>
            </div>
        </div>
    </div>
    
    <!-- Action Buttons -->
    <div class="action-buttons">
        <button class="btn-print" onclick="printA4()">
            <i class="fa fa-print"></i> Print A4
        </button>
        <button class="btn-print" onclick="print80mm()">
            <i class="fa fa-print"></i> Print 80mm
        </button>
        <button class="btn-download" onclick="downloadPDF()">
            <i class="fa fa-download"></i> Download PDF
        </button>
    </div>
    
    <script>
        function printA4() {
            // Set document title for printing
            var originalTitle = document.title;
            var depositId = '<?php echo str_pad($deposit->id, 6, '0', STR_PAD_LEFT); ?>';
            var depositDate = '<?php echo date('Y-m-d', strtotime($deposit_date)); ?>';
            document.title = 'Deposit_Receipt_' + depositId + '_' + depositDate;
            
            // Add print class for A4
            document.body.classList.add('print-a4');
            window.print();
            
            // Restore original title
            document.title = originalTitle;
            document.body.classList.remove('print-a4');
        }
        
        function print80mm() {
            // Set document title for printing
            var originalTitle = document.title;
            var depositId = '<?php echo str_pad($deposit->id, 6, '0', STR_PAD_LEFT); ?>';
            var depositDate = '<?php echo date('Y-m-d', strtotime($deposit_date)); ?>';
            document.title = 'Deposit_Receipt_' + depositId + '_' + depositDate;
            
            // Add print class for 80mm
            document.body.classList.add('print-80mm');
            window.print();
            
            // Restore original title
            document.title = originalTitle;
            document.body.classList.remove('print-80mm');
        }
        
        function downloadPDF() {
            // Set document title for PDF
            var originalTitle = document.title;
            var depositId = '<?php echo str_pad($deposit->id, 6, '0', STR_PAD_LEFT); ?>';
            var depositDate = '<?php echo date('Y-m-d', strtotime($deposit_date)); ?>';
            document.title = 'Deposit_Receipt_' + depositId + '_' + depositDate;
            
            // Trigger print dialog for PDF
            window.print();
            
            // Restore original title
            document.title = originalTitle;
        }
    </script>
</body>
</html>
