<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Money Transfer Receipt</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/css/AdminLTE.min.css">
    <style>
        @media print {
            .no-print { display: none !important; }
            .print-only { display: block !important; }
            body { font-size: 14px; margin: 0; padding: 0; }
            .receipt-container { margin: 0; padding: 15px; max-width: 100%; }
            .page-break { page-break-after: always; }
        }
        .print-only { display: none; }
        
        body { 
            font-family: Arial, sans-serif; 
            font-size: 12px; 
            line-height: 1.3;
            background: #f5f5f5;
            margin: 0;
            padding: 20px;
        }
        
        .receipt-container { 
            max-width: 600px; 
            margin: 0 auto; 
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        
        /* Header */
        .receipt-header {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 20px;
            text-align: center;
        }
        
        .company-name {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .receipt-title {
            font-size: 12px;
            opacity: 0.9;
            margin-bottom: 10px;
        }
        
        .receipt-number {
            background: rgba(255,255,255,0.2);
            padding: 5px 12px;
            border-radius: 15px;
            font-size: 11px;
            display: inline-block;
        }
        
        /* Status */
        .status-bar {
            background: #28a745;
            color: white;
            padding: 8px;
            text-align: center;
            font-size: 12px;
            font-weight: bold;
        }
        
        /* Content */
        .receipt-content {
            padding: 20px;
        }
        
        .amount-section {
            background: #e8f4fd;
            border: 2px solid #1e3c72;
            border-radius: 8px;
            padding: 15px;
            margin: 15px 0;
            text-align: center;
        }
        
        .amount-value {
            font-size: 24px;
            font-weight: bold;
            color: #1e3c72;
            margin: 5px 0;
        }
        
        @media print {
            .amount-value {
                font-size: 28px;
            }
        }
        
        .amount-currency {
            font-size: 14px;
            color: #666;
        }
        
        .info-section {
            margin: 15px 0;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 6px 0;
            border-bottom: 1px dotted #ddd;
            font-size: 12px;
        }
        
        @media print {
            .info-row {
                font-size: 14px;
                padding: 8px 0;
            }
        }
        
        .info-label {
            font-weight: bold;
            color: #666;
            min-width: 100px;
        }
        
        .info-value {
            color: #333;
        }
        
        .accounts-section {
            display: flex;
            gap: 15px;
            margin: 15px 0;
        }
        
        .account-box {
            flex: 1;
            border: 2px solid #e0e0e0;
            border-radius: 6px;
            padding: 15px;
        }
        
        .from-account {
            border-left-color: #dc3545;
        }
        
        .to-account {
            border-left-color: #28a745;
        }
        
        .account-title {
            font-weight: bold;
            font-size: 11px;
            color: #1e3c72;
            margin-bottom: 8px;
            text-transform: uppercase;
        }
        
        .account-name {
            font-weight: bold;
            font-size: 12px;
            margin-bottom: 5px;
        }
        
        .account-code {
            font-size: 10px;
            color: #666;
            margin-bottom: 8px;
        }
        
        @media print {
            .account-title {
                font-size: 13px;
            }
            .account-name {
                font-size: 14px;
            }
            .account-code {
                font-size: 12px;
            }
        }
        
        .balance-info {
            background: #f8f9fa;
            padding: 8px;
            border-radius: 4px;
            font-size: 10px;
        }
        
        @media print {
            .balance-info {
                font-size: 12px;
                padding: 10px;
            }
        }
        
        .balance-current {
            color: #666;
            display: block;
            margin-bottom: 2px;
        }
        
        .balance-new {
            font-weight: bold;
            color: #333;
            display: block;
        }
        
        /* Footer */
        .receipt-footer {
            background: #f8f9fa;
            padding: 15px;
            border-top: 2px solid #1e3c72;
            font-size: 10px;
        }
        
        @media print {
            .receipt-footer {
                font-size: 12px;
                padding: 20px;
            }
        }
        
        .footer-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        
        .company-info {
            flex: 1;
        }
        
        .signature-section {
            text-align: right;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            width: 120px;
            margin: 5px 0;
        }
        
        .terms {
            font-size: 9px;
            color: #666;
            text-align: center;
            margin-top: 10px;
        }
        
        /* Action Buttons */
        .action-buttons {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-top: 1px solid #e0e0e0;
        }
        
        .btn-group {
            display: inline-flex;
            gap: 10px;
            flex-wrap: wrap;
            justify-content: center;
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            font-size: 12px;
            font-weight: bold;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-primary:hover {
            background: #0056b3;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn-success:hover {
            background: #1e7e34;
            transform: translateY(-2px);
        }
        
        .btn-info {
            background: #17a2b8;
            color: white;
        }
        
        .btn-info:hover {
            background: #138496;
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #545b62;
            transform: translateY(-2px);
        }
        
        /* Print Optimizations */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            .receipt-container {
                box-shadow: none;
                border-radius: 0;
                margin: 0;
                max-width: 100%;
            }
            .receipt-header {
                background: #1e3c72 !important;
                -webkit-print-color-adjust: exact;
            }
            .amount-section {
                border-color: #1e3c72 !important;
                -webkit-print-color-adjust: exact;
            }
            .status-bar {
                background: #28a745 !important;
                -webkit-print-color-adjust: exact;
            }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .accounts-section {
                flex-direction: column;
            }
            .footer-row {
                flex-direction: column;
            }
            .signature-section {
                text-align: left;
                margin-top: 10px;
            }
            .btn-group {
                flex-direction: column;
                align-items: center;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="receipt-header">
            <div class="company-name"><?php echo $company_name; ?></div>
            <div class="receipt-title">MONEY TRANSFER RECEIPT</div>
            <div class="receipt-number">#<?php echo $transfer_code; ?></div>
        </div>
        
        <!-- Status -->
        <div class="status-bar">
            ✓ TRANSFER COMPLETED SUCCESSFULLY
        </div>
        
        <!-- Content -->
        <div class="receipt-content">
            <!-- Amount -->
            <div class="amount-section">
                <div class="amount-value"><?php echo $transfer_currency_symbol . ' ' . number_format($amount, 2); ?></div>
            </div>
            
            <!-- Transaction Info -->
            <div class="info-section">
                <div class="info-row">
                    <span class="info-label">Date:</span>
                    <span class="info-value"><?php echo date('M d, Y', strtotime($transfer_date)); ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Time:</span>
                    <span class="info-value"><?php echo date('h:i A', strtotime($transfer_date . ' ' . $transfer_time)); ?></span>
                </div>
                <?php if (!empty($reference_no)): ?>
                <div class="info-row">
                    <span class="info-label">Reference:</span>
                    <span class="info-value"><?php echo $reference_no; ?></span>
                </div>
                <?php endif; ?>
                <div class="info-row">
                    <span class="info-label">Processed By:</span>
                    <span class="info-value"><?php echo $created_by; ?></span>
                </div>
            </div>
            
            <!-- Accounts -->
            <div class="accounts-section">
                <div class="account-box from-account">
                    <div class="account-title">From Account</div>
                    <div class="account-name"><?php echo $from_account_name; ?></div>
                    <div class="account-code"><?php echo $from_account_code; ?></div>
                    <div class="balance-info">
                        <span class="balance-current">Current: <?php echo $from_currency_symbol . ' ' . number_format($from_current_balance, 2); ?></span>
                        <span class="balance-new">New: <?php echo $from_currency_symbol . ' ' . number_format($from_new_balance, 2); ?></span>
                    </div>
                </div>
                
                <div class="account-box to-account">
                    <div class="account-title">To Account</div>
                    <div class="account-name"><?php echo $to_account_name; ?></div>
                    <div class="account-code"><?php echo $to_account_code; ?></div>
                    <div class="balance-info">
                        <span class="balance-current">Current: <?php echo $to_currency_symbol . ' ' . number_format($to_current_balance, 2); ?></span>
                        <span class="balance-new">New: <?php echo $to_currency_symbol . ' ' . number_format($to_new_balance, 2); ?></span>
                    </div>
                </div>
            </div>
            
            <!-- Currency Conversion (only if needed) -->
            <?php if (!empty($conversion_info)): ?>
                <div class="info-section">
                    <div class="info-row">
                        <span class="info-label">Currency Conversion:</span>
                        <span class="info-value"><?php echo $conversion_info; ?></span>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Notes (only if exists) -->
            <?php if (!empty($note)): ?>
                <div class="info-section">
                    <div class="info-row">
                        <span class="info-label">Notes:</span>
                        <span class="info-value"><?php echo $note; ?></span>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Footer -->
        <div class="receipt-footer">
            <div class="footer-row">
                <div class="company-info">
                    <strong><?php echo $company_name; ?></strong><br>
                    <?php if (!empty($company_address)): ?>
                        <?php echo $company_address; ?><br>
                    <?php endif; ?>
                    <?php if (!empty($company_phone)): ?>
                        Phone: <?php echo $company_phone; ?><br>
                    <?php endif; ?>
                    <?php if (!empty($company_email)): ?>
                        Email: <?php echo $company_email; ?>
                    <?php endif; ?>
                </div>
                <div class="signature-section">
                    <div>Authorized Signature:</div>
                    <div class="signature-line"></div>
                    <div>Date: <?php echo date('M d, Y', strtotime($transfer_date)); ?></div>
                </div>
            </div>
            
            <div class="terms">
                Generated: <?php echo date('M d, Y h:i A'); ?> | This is a computer-generated receipt.
            </div>
        </div>
        
        <!-- Action Buttons -->
        <div class="action-buttons no-print">
            <div class="btn-group">
                <button onclick="printA4()" class="btn btn-primary">
                    <i class="fa fa-print"></i> Print A4
                </button>
                <button onclick="print80mm()" class="btn btn-success">
                    <i class="fa fa-print"></i> Print 80mm
                </button>
                <button onclick="downloadPDF()" class="btn btn-info">
                    <i class="fa fa-file-pdf-o"></i> Download PDF
                </button>
                <a href="<?php echo $base_url; ?>money_transfer" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> Back to Transfers
                </a>
            </div>
        </div>
    </div>

    <script>
        function downloadPDF() {
            // Set document title with date for PDF
            const originalTitle = document.title;
            const transferDate = '<?php echo date('Y-m-d', strtotime($transfer_date)); ?>';
            const transferCode = '<?php echo $transfer_code; ?>';
            document.title = `Money_Transfer_Receipt_${transferCode}_${transferDate}`;
            
            window.print();
            
            // Restore original title
            document.title = originalTitle;
        }
        
        function print80mm() {
            // Set document title with date for 80mm print
            const originalTitle = document.title;
            const transferDate = '<?php echo date('Y-m-d', strtotime($transfer_date)); ?>';
            const transferCode = '<?php echo $transfer_code; ?>';
            document.title = `Money_Transfer_Receipt_${transferCode}_${transferDate}`;
            
            // Add 80mm specific styling
            document.body.classList.add('print-80mm');
            window.print();
            document.body.classList.remove('print-80mm');
            
            // Restore original title
            document.title = originalTitle;
        }
        
        function printA4() {
            // Set document title with date for A4 print
            const originalTitle = document.title;
            const transferDate = '<?php echo date('Y-m-d', strtotime($transfer_date)); ?>';
            const transferCode = '<?php echo $transfer_code; ?>';
            document.title = `Money_Transfer_Receipt_${transferCode}_${transferDate}`;
            
            window.print();
            
            // Restore original title
            document.title = originalTitle;
        }
        
        // Add 80mm print styles
        const style = document.createElement('style');
        style.textContent = `
            @media print {
                .print-80mm .receipt-container {
                    max-width: 80mm;
                    margin: 0;
                    padding: 5px;
                    font-size: 10px;
                }
                .print-80mm .receipt-header {
                    padding: 10px;
                }
                .print-80mm .receipt-content {
                    padding: 10px;
                }
                .print-80mm .amount-value {
                    font-size: 20px;
                }
                .print-80mm .accounts-section {
                    flex-direction: column;
                    gap: 8px;
                }
                .print-80mm .account-box {
                    padding: 8px;
                }
                .print-80mm .receipt-footer {
                    padding: 8px;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>