<!DOCTYPE html>
<html>
<head>
    <!-- TABLES CSS CODE -->
    <?php $this->load->view('comman/code_css.php');?>
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php $this->load->view('sidebar');?>
        
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Multi-Currency Accounts Report
                    <small>View account balances by currency</small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php echo $base_url; ?>accounts">Accounts</a></li>
                    <li class="active">Multi-Currency Report</li>
                </ol>
                <div class="pull-right">
                    <a href="<?php echo $base_url; ?>accounts" class="btn btn-primary">
                        <i class="fa fa-arrow-left"></i> Back to Account List
                    </a>
                </div>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <!-- ********** ALERT MESSAGE START******* -->
                    <?php $this->load->view('comman/code_flashdata');?>
                    <!-- ********** ALERT MESSAGE END******* -->
                    
                    <div class="col-xs-12">
                        <div class="box box-primary">
                            <div class="box-header">
                                <h3 class="box-title">Account Balances by Currency</h3>
                                <div class="box-tools">
                                    <button class="btn btn-info" onclick="refreshReport()">
                                        <i class="fa fa-refresh"></i> Refresh
                                    </button>
                                    <button class="btn btn-success" onclick="printMultiCurrencyReport()" title="Print Report">
                                        <i class="fa fa-print"></i> Print A4
                                    </button>
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="table-responsive">
                                            <table id="multi-currency-table" class="table table-bordered table-striped">
                                                <thead class="bg-gray">
                                                    <tr>
                                                        <th>Account Code</th>
                                                        <th>Account Name</th>
                                                        <th>Currency</th>
                                                        <th>Balance (Original)</th>
                                                        <th>Balance (Base Currency)</th>
                                                        <th>Exchange Rate</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $balances = get_multi_currency_account_balances();
                                                    $base_currency = get_base_currency();
                                                    
                                                    foreach ($balances as $balance) {
                                                        $exchange_rate = 1.0;
                                                        if (!$balance['is_base_currency']) {
                                                            $exchange_rate = get_exchange_rate($balance['currency_id'], $base_currency->id);
                                                        }
                                                    ?>
                                                    <tr>
                                                        <td><?= $balance['account_code'] ?></td>
                                                        <td><?= $balance['account_name'] ?></td>
                                                        <td>
                                                            <span class="label label-info">
                                                                <?= $balance['currency_code'] ?>
                                                            </span>
                                                            <?php if ($balance['is_base_currency']): ?>
                                                                <small class="text-muted">(Base)</small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="text-right">
                                                            <strong class="currency-amount">
                                                                <?= $balance['currency_symbol'] ?><?= store_number_format($balance['balance']) ?>
                                                            </strong>
                                                            <br><small class="text-muted"><?= $balance['currency_code'] ?></small>
                                                        </td>
                                                        <td class="text-right">
                                                            <strong class="currency-amount base-currency">
                                                                <?= $base_currency->symbol ?><?= store_number_format($balance['balance_base']) ?>
                                                            </strong>
                                                            <br><small class="text-muted"><?= $base_currency->currency_code ?></small>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php if ($balance['is_base_currency']): ?>
                                                                <span class="text-muted">1.000000</span>
                                                            <?php else: ?>
                                                                <?= number_format($exchange_rate, 6) ?>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                    <?php } ?>
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-primary">
                                                        <th colspan="3" class="text-right">Total (Base Currency):</th>
                                                        <th class="text-right">
                                                            <strong class="currency-amount base-currency total-amount">
                                                                <?= $base_currency->symbol ?><?php
                                                                $total_base = 0;
                                                                foreach ($balances as $balance) {
                                                                    $total_base += $balance['balance_base'];
                                                                }
                                                                echo store_number_format($total_base);
                                                                ?>
                                                            </strong>
                                                            <br><small class="text-muted"><?= $base_currency->currency_code ?></small>
                                                        </th>
                                                        <th colspan="2"></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                        </div>
                        <!-- /.box -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->
        <?php $this->load->view('footer.php');?>
    </div>
    <!-- ./wrapper -->

    <!-- SOUND CODE -->
    <?php $this->load->view('comman/code_js_sound.php');?>
    <!-- TABLES CODE -->
    <?php $this->load->view('comman/code_js.php');?>
    
    <style>
    /* Enhanced styling for Multi-Currency Report */
    .currency-amount {
        font-size: 14px;
        font-weight: bold;
    }
    
    .base-currency {
        color: #2c3e50;
        background-color: #ecf0f1;
        padding: 2px 6px;
        border-radius: 3px;
    }
    
    .total-amount {
        font-size: 16px;
        color: #fff;
        background-color: #3498db;
        padding: 4px 8px;
        border-radius: 4px;
    }
    
    .label {
        font-size: 11px;
        padding: 3px 8px;
    }
    
    .text-muted {
        font-size: 10px;
        color: #7f8c8d;
    }
    
    /* Print styles */
    @media print {
        .box-tools, .btn, .no-print {
            display: none !important;
        }
        
        .currency-amount {
            font-size: 12px;
        }
        
        .total-amount {
            font-size: 14px;
        }
        
        .table {
            font-size: 11px;
        }
    }
    </style>

    <script type="text/javascript">
    $(document).ready(function() {
        // Initialize DataTable
        $('#multi-currency-table').DataTable({
            "responsive": true,
            "pageLength": 25,
            "order": [[ 2, "asc" ], [ 0, "asc" ]], // Sort by currency, then account code
            "columnDefs": [
                { "orderable": false, "targets": [5] } // Exchange rate column not sortable
            ]
        });
    });

    function refreshReport() {
        location.reload();
    }
    
    // Professional A4 Print Function for Multi-Currency Report
    function printMultiCurrencyReport() {
        // Check if report data exists
        if (!$('#multi-currency-table tbody').html() || $('#multi-currency-table tbody').html().trim() === '') {
            alert('Please generate the multi-currency report first before printing.');
            return;
        }
        
        // Create print window
        var printWindow = window.open('', '_blank', 'width=800,height=600');
        
        // Get company information dynamically
        var companyName = '<?php echo get_store_details()->store_name; ?>';
        var companyAddress = '<?php echo get_store_details()->address; ?>';
        var companyPhone = '<?php echo get_store_details()->phone; ?>';
        var companyEmail = '<?php echo get_store_details()->email; ?>';
        
        // Get current date
        var currentDate = new Date().toLocaleDateString();
        
        // Get base currency info
        var baseCurrency = '<?php echo $base_currency->currency_code; ?>';
        var baseSymbol = '<?php echo $base_currency->symbol; ?>';
        
        // Get table data
        var tableData = '';
        $('#multi-currency-table tbody tr').each(function() {
            var cells = $(this).find('td');
            if (cells.length > 0) {
                var accountCode = $(cells[0]).text().trim();
                var accountName = $(cells[1]).text().trim();
                var currency = $(cells[2]).find('.label').text().trim();
                var isBase = $(cells[2]).find('.text-muted').text().trim();
                var originalBalance = $(cells[3]).find('.currency-amount').text().trim();
                var baseBalance = $(cells[4]).find('.currency-amount').text().trim();
                var exchangeRate = $(cells[5]).text().trim();
                
                tableData += '<tr>';
                tableData += '<td>' + accountCode + '</td>';
                tableData += '<td>' + accountName + '</td>';
                tableData += '<td>' + currency + (isBase ? ' (Base)' : '') + '</td>';
                tableData += '<td class="text-right">' + originalBalance + '</td>';
                tableData += '<td class="text-right">' + baseBalance + '</td>';
                tableData += '<td class="text-center">' + exchangeRate + '</td>';
                tableData += '</tr>';
            }
        });
        
        // Get total
        var totalAmount = $('#multi-currency-table tfoot .total-amount').text().trim();
        
        // Build print content
        var printContent = `
            <!DOCTYPE html>
            <html>
            <head>
                <title>Multi-Currency Accounts Report</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        font-size: 12px;
                        line-height: 1.4;
                        margin: 0;
                        padding: 20px;
                        color: #333;
                    }
                    
                    .print-header {
                        text-align: center;
                        margin-bottom: 30px;
                        border-bottom: 2px solid #333;
                        padding-bottom: 20px;
                    }
                    
                    .print-header h1 {
                        margin: 0 0 10px 0;
                        font-size: 24px;
                        color: #2c3e50;
                    }
                    
                    .company-info {
                        margin: 2px 0;
                        color: #666;
                    }
                    
                    .report-title {
                        font-size: 18px;
                        font-weight: bold;
                        margin: 15px 0 10px 0;
                        color: #2c3e50;
                    }
                    
                    .report-filters {
                        margin: 3px 0;
                        font-size: 11px;
                        color: #666;
                    }
                    
                    .print-table {
                        width: 100%;
                        border-collapse: collapse;
                        margin: 20px 0;
                        font-size: 11px;
                    }
                    
                    .print-table th,
                    .print-table td {
                        border: 1px solid #ddd;
                        padding: 8px;
                        text-align: left;
                    }
                    
                    .print-table th {
                        background-color: #f8f9fa;
                        font-weight: bold;
                        text-align: center;
                    }
                    
                    .print-table .text-right {
                        text-align: right;
                    }
                    
                    .print-table .text-center {
                        text-align: center;
                    }
                    
                    .currency-amount {
                        font-weight: bold;
                    }
                    
                    .base-currency {
                        background-color: #ecf0f1;
                        padding: 2px 4px;
                        border-radius: 2px;
                    }
                    
                    .total-row {
                        background-color: #3498db;
                        color: white;
                        font-weight: bold;
                    }
                    
                    .print-footer {
                        margin-top: 30px;
                        text-align: center;
                        font-size: 10px;
                        color: #666;
                        border-top: 1px solid #ccc;
                        padding-top: 10px;
                    }
                </style>
            </head>
            <body>
                <div class="print-header">
                    <h1>${companyName}</h1>
                    <div class="company-info">${companyAddress}</div>
                    <div class="company-info">${companyPhone}</div>
                    <div class="company-info">${companyEmail}</div>
                    <div class="report-title">Multi-Currency Accounts Report</div>
                    <div class="report-filters"><strong>Base Currency:</strong> ${baseCurrency} (${baseSymbol})</div>
                    <div class="report-filters"><strong>Generated:</strong> ${currentDate}</div>
                </div>
                
                <table class="print-table">
                    <thead>
                        <tr>
                            <th>Account Code</th>
                            <th>Account Name</th>
                            <th>Currency</th>
                            <th>Balance (Original)</th>
                            <th>Balance (Base Currency)</th>
                            <th>Exchange Rate</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${tableData}
                    </tbody>
                    <tfoot>
                        <tr class="total-row">
                            <td colspan="3" class="text-right">Total (Base Currency):</td>
                            <td class="text-right">${totalAmount}</td>
                            <td colspan="2"></td>
                        </tr>
                    </tfoot>
                </table>
                
                <div class="print-footer">
                    <p>This report was generated on ${currentDate} by ${companyName} System</p>
                    <p>For any queries, please contact us at ${companyEmail}</p>
                </div>
            </body>
            </html>
        `;
        
        // Write content and print
        printWindow.document.write(printContent);
        printWindow.document.close();
        
        // Wait for content to load, then print
        printWindow.onload = function() {
            printWindow.focus();
            printWindow.print();
            printWindow.close();
        };
    }
    </script>

    <!-- Make sidebar menu highlighter/selector -->
    <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
</body>
</html>
