<!-- Export -->
      <script type="text/javascript" src="<?php echo $theme_link; ?>plugins/tableExporter/libs/js-xlsx/xlsx.core.min.js"></script>
      <script type="text/javascript" src="<?php echo $theme_link; ?>plugins/tableExporter/libs/jsPDF/jspdf.min.js"></script>
      <script type="text/javascript" src="<?php echo $theme_link; ?>plugins/tableExporter/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
      <script type="text/javascript" src="<?php echo $theme_link; ?>plugins/tableExporter/tableExport.min.js"></script>
<script>
      function downloadPdf(tableId){
            $('#'+tableId).tableExport({type:'pdf',escape:'false'});
      }
      function downloadExcel(tableId){
            // Generate filename with current date and time
            var now = new Date();
            var dateStr = now.getFullYear() + '-' + 
                         String(now.getMonth() + 1).padStart(2, '0') + '-' + 
                         String(now.getDate()).padStart(2, '0');
            var timeStr = String(now.getHours()).padStart(2, '0') + '-' + 
                         String(now.getMinutes()).padStart(2, '0');
            
            // Get filter information for filename
            var storeName = $('#store_id option:selected').text() || 'AllStores';
            var warehouseName = $('#warehouse_id option:selected').text() || 'AllWarehouses';
            var brandName = $('#brand_id option:selected').text() || 'AllBrands';
            var categoryName = $('#category_id option:selected').text() || 'AllCategories';
            
            // Clean names for filename
            storeName = storeName.replace(/[^a-zA-Z0-9]/g, '');
            warehouseName = warehouseName.replace(/[^a-zA-Z0-9]/g, '');
            brandName = brandName.replace(/[^a-zA-Z0-9]/g, '');
            categoryName = categoryName.replace(/[^a-zA-Z0-9]/g, '');
            
            // Determine report type based on table ID
            var reportType = '';
            switch(tableId) {
                case 'report-data':
                    reportType = 'ItemWiseStock';
                    break;
                case 'brand_wise_stock':
                    reportType = 'BrandWiseStock';
                    break;
                case 'stock_aging':
                    reportType = 'StockAging';
                    break;
                case 'most_moving':
                    reportType = 'MostMovingStock';
                    break;
                case 'less_moving':
                    reportType = 'LessMovingStock';
                    break;
                default:
                    reportType = 'StockReport';
            }
            
            var filename = reportType + '_' + storeName + '_' + warehouseName + '_' + 
                          brandName + '_' + categoryName + '_' + dateStr + '_' + timeStr;
            
            // Use the filename in the export
            $('#'+tableId).tableExport({
                type:'xlsx',
                escape:'false',
                fileName: filename
            });
      }
      $(".downloadPdf").on("click",function(){
            var tableId=$(this).attr("data-table-id");
            downloadPdf(tableId);
      });
      $(".downloadExcel").on("click",function(){
            var tableId=$(this).attr("data-table-id");
            downloadExcel(tableId);
      });
</script>