<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php print $SITE_TITLE; ?> | Log in</title>
  <link rel='shortcut icon' href='<?php echo $theme_link; ?>images/favicon.ico' />
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  
  <!-- Optimized CSS Loading -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo $theme_link; ?>dist/css/AdminLTE.min.css">
  <!-- Font Awesome for icons -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>css/font-awesome-4.7.0/css/font-awesome.min.css">
  
  <!-- Inline Critical CSS for faster rendering -->
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body { 
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }
    .auth-container {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 15px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
      padding: <?php echo demo_app() ? '15px' : '20px'; ?>;
      width: 100%;
      max-width: 400px;
      position: relative;
      overflow: hidden;
    }
    .auth-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 3px;
      background: linear-gradient(90deg, #667eea, #764ba2, #f093fb);
    }
    .auth-header { text-align: center; margin-bottom: 25px; }
    .auth-logo { margin: 0 auto 15px; display: flex; align-items: center; justify-content: center; }
    .auth-logo img { max-width: 120px; max-height: 60px; width: auto; height: auto; }
    .auth-title { font-size: 24px; font-weight: 700; color: #2d3748; margin-bottom: 5px; }
    .auth-subtitle { color: #718096; font-size: 14px; }
    .form-group { margin-bottom: 20px; position: relative; }
    .form-control {
      width: 100%;
      padding: 12px 15px 12px 45px;
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      font-size: 14px;
      transition: all 0.3s ease;
      background: #f8fafc;
    }
    .form-control:focus {
      outline: none;
      border-color: #667eea;
      background: #fff;
      box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.1);
    }
    .form-control::placeholder { color: #a0aec0; }
    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #a0aec0;
      font-size: 16px;
      transition: color 0.3s ease;
    }
    .form-control:focus + .input-icon { color: #667eea; }
    .btn-login {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #667eea, #764ba2);
      border: none;
      border-radius: 8px;
      color: white;
      font-size: 14px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }
    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
    }
    .btn-login:disabled {
      opacity: 0.7;
      cursor: not-allowed;
      transform: none;
    }
    .auth-bottom-section {
      margin-top: 25px;
      padding-top: 20px;
      border-top: 1px solid #e2e8f0;
    }
    .auth-links {
      display: flex;
      justify-content: center;
      gap: 20px;
      margin-bottom: 20px;
      flex-wrap: wrap;
    }
    .auth-link {
      color: #667eea;
      text-decoration: none;
      font-weight: 500;
      font-size: 14px;
      transition: color 0.3s ease;
      display: flex;
      align-items: center;
      gap: 6px;
    }
    .auth-link:hover {
      color: #764ba2;
      text-decoration: none;
    }
    .alert {
      padding: 10px 12px;
      border-radius: 6px;
      margin-bottom: 15px;
      font-weight: 500;
      font-size: 13px;
    }
    .alert-danger { background: #fed7d7; color: #c53030; border: 1px solid #feb2b2; }
    .alert-success { background: #c6f6d5; color: #2f855a; border: 1px solid #9ae6b4; }
    .alert-warning { background: #fef5e7; color: #d69e2e; border: 1px solid #fbd38d; }
    .alert-info { background: #bee3f8; color: #2b6cb0; border: 1px solid #90cdf4; }
    .language-selector { 
      text-align: center; 
      margin-top: 15px;
    }
    .modern-language-wrapper {
      display: inline-block;
      background: #f8f9fa;
      padding: 10px 15px;
      border-radius: 10px;
      border: 1px solid #e9ecef;
      transition: all 0.3s ease;
      min-width: 180px;
    }
    .modern-language-wrapper:hover {
      background: #f1f3f5;
      border-color: #dee2e6;
    }
    .modern-language-label {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
      margin-bottom: 8px;
      font-size: 13px;
      color: #667eea;
      font-weight: 600;
    }
    .modern-language-label i {
      font-size: 14px;
    }
    .modern-language-select {
      width: 100%;
      border: 2px solid #e2e8f0;
      border-radius: 6px;
      padding: 8px 12px;
      font-size: 14px;
      color: #495057;
      background: white;
      transition: all 0.3s ease;
      font-weight: 500;
      cursor: pointer;
    }
    .modern-language-select:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    .modern-language-select:hover {
      border-color: #cbd5e0;
    }
    .loading {
      display: inline-block;
      width: 20px;
      height: 20px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-radius: 50%;
      border-top-color: #fff;
      animation: spin 1s ease-in-out infinite;
    }
    @keyframes spin { to { transform: rotate(360deg); } }
    
    /* Responsive Design */
    @media (max-width: 768px) {
      .auth-container { padding: 25px 20px; margin: 15px; max-width: calc(100% - 30px); }
      .auth-title { font-size: 26px; }
      .auth-subtitle { font-size: 15px; }
      .form-control { padding: 12px 14px 12px 45px; font-size: 15px; min-height: 48px; }
      .btn-login { padding: 12px; font-size: 15px; min-height: 48px; }
      .auth-links { gap: 15px; margin-bottom: 15px; }
      .auth-link { font-size: 14px; }
      .modern-language-wrapper { padding: 8px 12px; min-width: 160px; }
      .modern-language-label { font-size: 12px; margin-bottom: 6px; }
      .modern-language-select { font-size: 14px; padding: 7px 10px; }
      .alert { padding: 10px 14px; font-size: 14px; }
      .auth-logo img { max-width: 130px; max-height: 65px; }
    }
    @media (max-width: 480px) {
      .auth-container { padding: 20px 15px; margin: 10px; max-width: calc(100% - 20px); }
      .auth-title { font-size: 24px; }
      .auth-subtitle { font-size: 14px; }
      .form-control { padding: 14px 16px 14px 45px; font-size: 16px; min-height: 50px; }
      .btn-login { padding: 14px; font-size: 16px; min-height: 50px; }
      .auth-logo img { max-width: 140px; max-height: 70px; }
      .auth-links { gap: 12px; margin-bottom: 12px; }
      .auth-link { font-size: 14px; }
      .modern-language-wrapper { padding: 8px 10px; min-width: 150px; }
      .modern-language-label { font-size: 12px; margin-bottom: 6px; }
      .modern-language-select { font-size: 14px; padding: 6px 8px; }
      .alert { padding: 12px 16px; font-size: 14px; }
    }
  </style>
  
  <?php 
      $lang = trim(strtoupper($this->session->userdata('language')));
      if($lang==strtoupper('arabic') || $lang==strtoupper('urdu')) {?>
  <!-- RTL For arabic styles -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>bootstrap/css/bootstrap.rtl.min.css">
  <link rel="stylesheet" href="<?php echo $theme_link; ?>dist/css/AdminLTE.rtl.min.css">
  <?php } ?>
</head>
<body>
  <input type="hidden" id="base_url" value="<?=base_url()?>">

  <div class="auth-container">
    <div class="auth-header">
      <div class="auth-logo">
        <img src="<?php echo base_url(get_site_logo());?>" alt="Logo">
      </div>
      <h1 class="auth-title">Welcome Back</h1>
      <p class="auth-subtitle"><?= $this->lang->line('sign_in_message'); ?></p>
    </div>

    <!-- Alert Messages -->
    <?php if($this->session->flashdata('failed')): ?>
      <div class="alert alert-danger">
        <i class="fa fa-exclamation-circle"></i> <?php echo $this->session->flashdata('failed'); ?>
      </div>
    <?php endif; ?>
    
    <?php if($this->session->flashdata('success')): ?>
      <div class="alert alert-success">
        <i class="fa fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
      </div>
    <?php endif; ?>
    
    <?php if($this->session->flashdata('error')): ?>
      <div class="alert alert-warning">
        <i class="fa fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('error'); ?>
      </div>
    <?php endif; ?>
    
    <?php if($this->session->flashdata('info')): ?>
      <div class="alert alert-info">
        <i class="fa fa-info-circle"></i> <?php echo $this->session->flashdata('info'); ?>
      </div>
    <?php endif; ?>
    
    <!-- Compact Role Selector -->
    <?php if(demo_app()): ?>
      <div class="compact-role-selector">
        <label class="role-selector-label"><i class="fa fa-users"></i> Login as:</label>
        <div class="role-buttons-compact">
          <button type="button" class="role-btn-compact active" data-role="admin" data-email="admin@example.com" data-password="123456">
            <i class="fa fa-user-shield"></i> <span>Admin</span>
          </button>
          <button type="button" class="role-btn-compact" data-role="manager" data-email="manager@example.com" data-password="123456">
            <i class="fa fa-user-tie"></i> <span>Manager</span>
          </button>
          <button type="button" class="role-btn-compact" data-role="cashier" data-email="cashier@example.com" data-password="123456">
            <i class="fa fa-user"></i> <span>Cashier</span>
          </button>
        </div>
      </div>
    <?php endif; ?>

    <form id="login-form" action="<?php echo $base_url; ?>login/verify" method="post">
      <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
      
      <div class="form-group">
        <input type="text" class="form-control" placeholder="Email or Username" id="email" name="email" autofocus required <?php if(demo_app()): ?>readonly value="admin@example.com"<?php endif; ?>>
        <i class="fa fa-envelope input-icon"></i>
      </div>
      
      <div class="form-group">
        <input type="password" class="form-control" placeholder="Password" id="pass" name="pass" required <?php if(demo_app()): ?>readonly value="123456"<?php endif; ?>>
        <i class="fa fa-lock input-icon"></i>
       </div>
       
      <button type="submit" class="btn-login" id="login-btn">
        <span class="btn-text"><?= $this->lang->line('sign_in'); ?></span>
        <span class="loading" style="display: none;"></span>
      </button>
      
      <!-- Compact Buy Now Section -->
      <?php if(demo_app()): ?>
        <div class="demo-footer-compact">
          <div class="demo-buy-buttons">
            <a href="https://nanzige.gumroad.com/l/billingbook" target="_blank" class="demo-link-compact demo-gumroad">
              <i class="fa fa-shopping-cart"></i> Buy via Gumroad
            </a>
            <a href="https://nanzige.com/checkout/?add-to-cart=3200" target="_blank" class="demo-link-compact demo-site">
              <i class="fa fa-globe"></i> Buy via Site
            </a>
          </div>
          <p class="demo-price-text">Only $35 - Limited time offer!</p>
        </div>
      <?php endif; ?>
    </form>

    <!-- Auth Links and Language Section -->
    <div class="auth-bottom-section">
      <div class="auth-links">
        <?php if(store_module()): ?>
          <a href="<?=base_url('register')?>" class="auth-link">
            <i class="fa fa-user-plus"></i> <?= $this->lang->line('register'); ?>
          </a>
        <?php endif; ?>
        <a href="<?=base_url('login/forgot_password')?>" class="auth-link">
          <i class="fa fa-key"></i> <?= $this->lang->line('forgot_password'); ?>
        </a>
      </div>

      <!-- Language Selector -->
      <div class="language-selector">
        <?php $this->load->view('comman/language.php');?>
      </div>
    </div>


  </div>

<!-- Optimized JavaScript Loading -->
<script src="<?php echo $theme_link; ?>plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="<?php echo $theme_link; ?>bootstrap/js/bootstrap.min.js"></script>
<script src="<?php echo $theme_link; ?>js/language.js"></script>
  
<script>
    $(document).ready(function() {
      // Setup AJAX CSRF token
      $.ajaxSetup({ 
        data: {'<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>' }  
      });

      // Form submission with loading state
      $('#login-form').on('submit', function(e) {
        const $btn = $('#login-btn');
        const $btnText = $btn.find('.btn-text');
        const $loading = $btn.find('.loading');
        
        // Show loading state
        $btn.prop('disabled', true);
        $btnText.hide();
        $loading.show();
      });

      // Role selector functionality (works for both .role-btn and .role-btn-compact)
      $('.role-btn, .role-btn-compact').on('click', function(e) {
        e.preventDefault();
        
        // Remove active class from all buttons
        $('.role-btn, .role-btn-compact').removeClass('active');
        
        // Add active class to clicked button
        $(this).addClass('active');
        
        // Get credentials from data attributes
        const email = $(this).data('email');
        const password = $(this).data('password');
        
        // Update form fields
        $("input[name='email']").val(email);
        $("input[name='pass']").val(password);
      });

      // Add focus effects to form inputs
      $('.form-control').on('focus', function() {
        $(this).parent().addClass('focused');
      }).on('blur', function() {
        if ($(this).val() === '') {
          $(this).parent().removeClass('focused');
        }
      });

      // Check if inputs have values on page load
      $('.form-control').each(function() {
        if ($(this).val() !== '') {
          $(this).parent().addClass('focused');
        }
      });
    });
</script>

<!-- Simple Demo Styles -->
<?php if(demo_app()): ?>
<style>
.demo-footer-compact {
  margin-top: 12px;
  text-align: center;
}
.demo-buy-buttons {
  display: flex;
  gap: 8px;
  justify-content: center;
  flex-wrap: wrap;
}
.demo-link-compact {
  display: inline-block;
  padding: 8px 14px;
  color: white;
  border-radius: 6px;
  text-decoration: none;
  font-size: 12px;
  font-weight: 600;
  transition: all 0.3s ease;
  flex: 1;
  text-align: center;
  min-width: 140px;
}
.demo-gumroad {
  background: linear-gradient(135deg, #667eea, #764ba2);
}
.demo-site {
  background: linear-gradient(135deg, #ff6b6b, #ee5a24);
}
.demo-link-compact:hover {
  transform: translateY(-2px);
  box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
  color: white;
  text-decoration: none;
}
.demo-link-compact i {
  margin-right: 5px;
}
.demo-price-text {
  margin-top: 8px;
  font-size: 11px;
  color: #667eea;
  font-weight: 600;
}

.compact-role-selector {
  background: #f8f9fa;
  border-radius: 8px;
  padding: 10px 8px;
  margin-bottom: 15px;
  border: 1px solid #e9ecef;
}
.role-selector-label {
  display: block;
  text-align: center;
  font-size: 12px;
  color: #495057;
  font-weight: 600;
  margin-bottom: 8px;
}
.role-selector-label i {
  margin-right: 5px;
  color: #667eea;
}
.role-buttons-compact {
  display: flex;
  gap: 6px;
  justify-content: center;
}
.role-btn-compact {
  background: white;
  border: 2px solid #dee2e6;
  color: #495057;
  padding: 6px 10px;
  border-radius: 6px;
  font-size: 12px;
  cursor: pointer;
  transition: all 0.3s ease;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 5px;
  flex: 1;
  white-space: nowrap;
}
.role-btn-compact:hover {
  border-color: #667eea;
  color: #667eea;
  transform: translateY(-1px);
}
.role-btn-compact.active {
  background: #667eea;
  border-color: #667eea;
  color: white;
  box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);
}
.role-btn-compact i {
  font-size: 13px;
}

/* Read-only field styling */
.form-control[readonly] {
  background-color: #f8f9fa;
  border-color: #dee2e6;
  color: #495057;
  cursor: not-allowed;
}
.form-control[readonly]:focus {
  border-color: #dee2e6;
  box-shadow: none;
  background-color: #f8f9fa;
}

/* Responsive adjustments */
@media (max-width: 768px) {
  .compact-role-selector {
    padding: 8px 6px;
    margin-bottom: 12px;
  }
  .role-selector-label {
    font-size: 11px;
    margin-bottom: 6px;
  }
  .role-buttons-compact {
    gap: 4px;
  }
  .role-btn-compact {
    padding: 5px 8px;
    font-size: 11px;
  }
  .role-btn-compact i {
    font-size: 12px;
  }
  .demo-buy-buttons {
    flex-direction: column;
    gap: 6px;
  }
  .demo-link-compact {
    min-width: 100%;
  }
}
@media (max-width: 480px) {
  .compact-role-selector {
    padding: 6px 4px;
    margin-bottom: 10px;
  }
  .role-selector-label {
    font-size: 10px;
  }
  .role-btn-compact {
    padding: 5px 6px;
    font-size: 10px;
    gap: 3px;
  }
  .role-btn-compact i {
    font-size: 11px;
  }
  .demo-link-compact {
    font-size: 11px;
    padding: 6px 10px;
  }
}
</style>
<?php endif; ?>

</body>
</html>
