<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?= $page_title; ?> | <?= get_store_details()->store_name; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/custom.css">
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php include "sidebar.php"; ?>
        
        <div class="content-wrapper">
            <section class="content-header">
                <h1>
                    <i class="fa fa-eye text-primary"></i>
                    <?= $page_title; ?>
                    <small>View Purchase Requisition Details</small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="<?= base_url(); ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?= base_url(); ?>purchase_requisitions">Purchase Requisitions</a></li>
                    <li class="active">View</li>
                </ol>
            </section>
            
            <section class="content">
                <!-- Alert Messages -->
                <div class="row">
                    <?php include "comman/code_flashdata.php"; ?>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title">
                                    <i class="fa fa-file-text-o"></i> Requisition Details
                                </h3>
                                <div class="box-tools pull-right">
                                    <a href="<?= base_url(); ?>purchase_requisitions" class="btn btn-default btn-sm">
                                        <i class="fa fa-arrow-left"></i> Back to List
                                    </a>
                                </div>
                            </div>
                            
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th width="30%">Requisition Code:</th>
                                                <td><?= $requisition->requisition_code; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Date:</th>
                                                <td><?= date('d-m-Y', strtotime($requisition->requisition_date)); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Requested By:</th>
                                                <td><?= $requisition->requested_by_name ?: 'Unknown'; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Priority:</th>
                                                <td>
                                                    <span class="label label-<?= $requisition->priority == 'High' ? 'danger' : ($requisition->priority == 'Medium' ? 'warning' : 'info'); ?>">
                                                        <?= ucfirst($requisition->priority); ?>
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Status:</th>
                                                <td>
                                                    <span class="label label-<?= $requisition->status == 'Pending' ? 'warning' : ($requisition->status == 'Approved' ? 'success' : ($requisition->status == 'Rejected' ? 'danger' : 'info')); ?>">
                                                        <?= ucfirst($requisition->status); ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th width="30%">Warehouse:</th>
                                                <td><?= $requisition->warehouse_name ?: 'Not specified'; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Store:</th>
                                                <td><?= $requisition->store_name ?: 'Not specified'; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Currency:</th>
                                                <td><?= $requisition->currency_name ?: 'US Dollar'; ?><?= !empty($requisition->currency_symbol) ? ' (' . $requisition->currency_symbol . ')' : ''; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Total Amount:</th>
                                                <td><strong><?= store_currency_format($requisition->total_amount); ?></strong></td>
                                            </tr>
                                            <?php if ($requisition->approved_by): ?>
                                            <tr>
                                                <th>Approved By:</th>
                                                <td><?= $requisition->approved_by; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Approved Date:</th>
                                                <td><?= date('d-m-Y H:i', strtotime($requisition->approved_date)); ?></td>
                                            </tr>
                                            <?php endif; ?>
                                            <?php if ($requisition->rejected_by): ?>
                                            <tr>
                                                <th>Rejected By:</th>
                                                <td><?= $requisition->rejected_by; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Rejected Date:</th>
                                                <td><?= date('d-m-Y H:i', strtotime($requisition->rejected_date)); ?></td>
                                            </tr>
                                            <?php if ($requisition->rejection_reason): ?>
                                            <tr>
                                                <th>Rejection Reason:</th>
                                                <td><?= $requisition->rejection_reason; ?></td>
                                            </tr>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </table>
                                    </div>
                                </div>
                                
                                <?php if ($requisition->notes): ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <h4>Notes:</h4>
                                        <div class="well"><?= nl2br($requisition->notes); ?></div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <h4>Items:</h4>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>Item</th>
                                                        <th>Description</th>
                                                        <th>Quantity</th>
                                                        <th>Unit Price</th>
                                                        <th>Total Price</th>
                                                        <th>Supplier</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($items)): ?>
                                                        <?php foreach($items as $item): ?>
                                                        <tr>
                                                            <td><?= $item->item_name ?: 'N/A'; ?></td>
                                                            <td><?= $item->description ?: 'N/A'; ?></td>
                                                            <td><?= number_format($item->requested_qty, 2); ?></td>
                                                            <td><?= store_currency_format($item->unit_price); ?></td>
                                                            <td><?= store_currency_format($item->total_price); ?></td>
                                                            <td><?= $item->supplier_name ?: 'N/A'; ?></td>
                                                            <td>
                                                                <span class="label label-<?= $item->status == 'Pending' ? 'warning' : ($item->status == 'Approved' ? 'success' : 'info'); ?>">
                                                                    <?= ucfirst($item->status); ?>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="7" class="text-center">No items found</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="box-footer">
                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        <?php if ($requisition->status == 'Pending'): ?>
                                        <button type="button" class="btn btn-success" onclick="approveRequisition(<?= $requisition->id; ?>)">
                                            <i class="fa fa-check"></i> Approve
                                        </button>
                                        <button type="button" class="btn btn-danger" onclick="rejectRequisition(<?= $requisition->id; ?>)">
                                            <i class="fa fa-times"></i> Reject
                                        </button>
                                        <?php endif; ?>
                                        <?php if ($requisition->status == 'Approved'): ?>
                                        <button type="button" class="btn btn-primary" onclick="convertToPurchase(<?= $requisition->id; ?>)">
                                            <i class="fa fa-shopping-cart"></i> Convert to Purchase
                                        </button>
                                        <?php endif; ?>
                                        <a href="<?= base_url(); ?>purchase_requisitions" class="btn btn-default">
                                            <i class="fa fa-arrow-left"></i> Back to List
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        
        <!-- Footer -->
        <?php include"footer.php"; ?>
      </div>
      <!-- ./wrapper -->

      <script src="<?= base_url(); ?>assets/js/jquery.min.js"></script>
      <script src="<?= base_url(); ?>assets/js/bootstrap.min.js"></script>
      <script src="<?= base_url(); ?>assets/js/app.min.js"></script>
      <!-- Make sidebar menu highlighter/selector -->
      <script>$(".purchase-requisition-view-active-li").addClass("active");</script>
   </body>
</html>

    <script>
    // Approve requisition
    function approveRequisition(id) {
        if (confirm('Are you sure you want to approve this requisition?')) {
            $.ajax({
                url: '<?= base_url(); ?>purchase_requisitions/approve/' + id,
                type: 'POST',
                data: {
                    '<?php echo $this->security->get_csrf_token_name();?>': '<?php echo $this->security->get_csrf_hash();?>'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert('Requisition approved successfully!');
                        location.reload();
                    } else {
                        alert('Error: ' + (response.message || 'Failed to approve requisition'));
                    }
                },
                error: function() {
                    alert('Error: Failed to approve requisition');
                }
            });
        }
    }

    // Reject requisition
    function rejectRequisition(id) {
        var reason = prompt('Please enter rejection reason:');
        if (reason !== null && reason.trim() !== '') {
            $.ajax({
                url: '<?= base_url(); ?>purchase_requisitions/reject/' + id,
                type: 'POST',
                data: {
                    reason: reason,
                    '<?php echo $this->security->get_csrf_token_name();?>': '<?php echo $this->security->get_csrf_hash();?>'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert('Requisition rejected successfully!');
                        location.reload();
                    } else {
                        alert('Error: ' + (response.message || 'Failed to reject requisition'));
                    }
                },
                error: function() {
                    alert('Error: Failed to reject requisition');
                }
            });
        }
    }

    // Convert to purchase
    function convertToPurchase(id) {
        if (confirm('Are you sure you want to convert this requisition to a purchase order?')) {
            window.location.href = '<?= base_url(); ?>purchase_requisitions/convert_to_purchase/' + id;
        }
    }
    </script>
</body>
</html>
