<!DOCTYPE html>
<html>
   <head>
      <!-- TABLES CSS CODE -->
      <?php include"comman/code_css.php"; ?>
      <!-- </copy> -->  
   </head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">Please Enter Valid Information</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <!-- Store Code -->
                                  <?php if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true')); }else{
                                     echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                                     }?>
                                  <!-- Store Code end -->
                                </div>
                                <div class="form-group">
                                  
                                 <label for="customer_id" class="col-sm-2 control-label"><?= $this->lang->line('customer_name'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="customer_id" name="customer_id" >
                                    </select>
                                    <span id="customer_id_msg" style="display:none" class="text-danger"></span>
                                 </div>

                              </div>
                              
                              <div class="form-group">
                                 <label for="within_date" class="col-sm-2 control-label"><?= $this->lang->line('order_within_from_the_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="within_date" name="within_date">
                                    </div>
                                    <span id="within_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>

                            

                           </div>

                           <!-- /.box-body -->
                           <div class="box-footer">
                           <div class="col-sm-8 col-sm-offset-2 text-center">
                              <div class="col-md-3 col-md-offset-3">
                                 <button type="button" id="view" class=" btn btn-block btn-success" title="Save Data">Show</button>
                              </div>
                              <div class="col-sm-3">
                                 <button type="button" id="print_a4" class="btn btn-block btn-info" title="Print A4">Print A4</button>
                              </div>
                              <div class="col-sm-3">
                                 <a href="<?=base_url('dashboard');?>">
                                 <button type="button" class="col-sm-3 btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                                 </a>
                              </div>
                           </div>
                           </div>
                           

                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <?php $this->load->view('components/export_btn',array('tableId' => 'report-data'));?>
                        </div>

                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <table class="table table-bordered table-hover " id="report-data" >
                              <thead>
                                 <tr class="bg-blue">
                                    <th style="">#</th>
                                    <?php if(store_module() && is_admin()){ ?>
                                    <th style=""><?= $this->lang->line('store_name'); ?></th>
                                    <?php } ?>
                                    <th style=""><?= $this->lang->line('customer_name'); ?></th>
                                    <th style=""><?= $this->lang->line('last_order_date'); ?></th>
                                    <th style=""><?= $this->lang->line('order_id'); ?></th>
                                    <th style=""><?= $this->lang->line('no_orders'); ?>(in Days)</th>
                                 </tr>
                              </thead>
                              <tbody id="tbodyid">
                              </tbody>
                           </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>
      <!-- TABLE EXPORT CODE -->
      <?php include"comman/code_js_export.php"; ?>

      <script src="<?php echo $theme_link; ?>js/sheetjs.js" type="text/javascript"></script>
      <script src="<?php echo $theme_link; ?>js/ajaxselect/customer_select_ajax.js"></script>  
      <script type="text/javascript">
         //Customer Selection Box Search
         function getCustomerSelectionId() {
           return '#customer_id';
         }
         //Customer Selection Box Search - END
      </script>
      <script type="text/javascript">
        var base_url=$("#base_url").val();
        $("#store_id").on("change",function(){
          autoLoadFirstCustomer();
        });
      </script>
      <script type="text/javascript">
         
         $("#view,#view_all").on("click",function(){
         var within_date=document.getElementById("within_date").value;
         var customer_id=document.getElementById("customer_id").value;
   
         if(this.id=="view_all"){
             var view_all='yes';
           }
        else{
          var view_all='no';
        }
      
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $.post($("#base_url").val()+"reports/show_customer_orders",{customer_id:customer_id,view_all:view_all,within_date:within_date,store_id:$("#store_id").val()},function(result){
          //alert(result);
            setTimeout(function() {
             $("#tbodyid").empty().append(result);     
             $(".overlay").remove();
            }, 0);
           });
     });

     // Print A4 functionality
     $("#print_a4").on("click", function() {
         printCustomerOrdersReport();
     });

     function printCustomerOrdersReport() {
         // Check if report data exists
         if ($("#tbodyid").html().trim() === '') {
             alert('Please generate the report first before printing.');
             return;
         }
         
         var within_date = $("#within_date").val();
         var customer_id = $("#customer_id").val();
         var store_id = $("#store_id").val();
         
         // Get company information
         var companyName = "<?php echo get_store_name(get_current_store_id()); ?>";
         var storeDetails = <?php echo json_encode(get_store_details(get_current_store_id())); ?>;
         var companyAddress = storeDetails ? storeDetails.address : '';
         var companyPhone = storeDetails ? storeDetails.phone : '';
         var companyEmail = storeDetails ? storeDetails.email : '';
         
         // Get report period
         var reportPeriod = '';
         if (within_date) {
             reportPeriod = 'Orders within: ' + within_date;
         } else {
             reportPeriod = 'All Orders';
         }
         
         // Get customer name if selected
         var customerName = '';
         if (customer_id) {
             customerName = $('#customer_id option:selected').text();
         }
         
         // Check if store module is enabled
         var showStoreColumn = <?php echo (store_module() && is_admin()) ? 'true' : 'false'; ?>;
         
         // Create print content
         var printContent = `
             <!DOCTYPE html>
             <html>
             <head>
                 <title>Customer Orders Report</title>
                 <style>
                     body { font-family: Arial, sans-serif; font-size: 12px; margin: 30px 20px; }
                     .header { text-align: center; margin-bottom: 20px; margin-top: 20px; }
                     .company-name { font-size: 18px; font-weight: bold; margin-bottom: 5px; }
                     .company-details { font-size: 12px; margin-bottom: 10px; }
                     .report-title { font-size: 16px; font-weight: bold; margin-bottom: 10px; }
                     .report-info { margin-bottom: 15px; }
                     table { width: 100%; border-collapse: collapse; margin-top: 10px; }
                     th, td { border: 1px solid #000; padding: 8px; text-align: left; }
                     th { background-color: #f0f0f0; font-weight: bold; }
                     .text-center { text-align: center; }
                     .text-right { text-align: right; }
                     .no-records { text-align: center; color: #666; font-style: italic; }
                     @media print { 
                         body { margin: 30px 20px; } 
                         .header { margin-top: 20px; }
                     }
                 </style>
             </head>
             <body>
                 <div class="header">
                     <div class="company-name">${companyName}</div>
                     <div class="company-details">
                         ${companyAddress}<br>
                         Phone: ${companyPhone} | Email: ${companyEmail}
                     </div>
                     <div class="report-title">Customer Orders Report</div>
                     <div class="report-info">
                         ${reportPeriod}
                         ${customerName ? '<br>Customer: ' + customerName : ''}
                     </div>
                 </div>
                 
                 <table>
                     <thead>
                         <tr>
                             <th>#</th>
                             ${showStoreColumn ? '<th>Store Name</th>' : ''}
                             <th>Customer Name</th>
                             <th>Last Order Date</th>
                             <th>Order ID</th>
                             <th>No Orders (in Days)</th>
                         </tr>
                     </thead>
                     <tbody>
                         ${$("#tbodyid").html()}
                     </tbody>
                 </table>
                 
                 <div style="margin-top: 20px; font-size: 10px; text-align: center;">
                     Generated on: ${new Date().toLocaleString()}
                 </div>
             </body>
             </html>
         `;
         
         // Open print window
         var printWindow = window.open('', '_blank', 'width=800,height=600');
         printWindow.document.write(printContent);
         printWindow.document.close();
         printWindow.focus();
         setTimeout(function() {
             printWindow.print();
             printWindow.close();
         }, 500);
     }
      </script>
      
      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li , .reports-menu").addClass("active");</script>
   </body>
</html>
