<!DOCTYPE html>
<html>
   <head>
      <!-- TABLES CSS CODE -->
      <?php include"comman/code_css.php"; ?>
      <!-- </copy> -->  
   </head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">Please Enter Valid Information</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <!-- Store Code -->
                                  <?php if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true')); }else{
                                     echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                                     }?>
                                  <!-- Store Code end -->
                                </div>
                                <div class="form-group">
                                  <!-- Warehouse Code -->
                                  <?php if(true) {$this->load->view('warehouse/warehouse_code',array('show_warehouse_select_box'=>true,'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true','show_all_option'=>true)); }else{
                                     echo "<input type='hidden' name='warehouse_id' id='warehouse_id' value='".get_store_warehouse_id()."'>";
                                     }?>
                                  <!-- Warehouse Code end -->
                                 <label for="customer_id" class="col-sm-2 control-label"><?= $this->lang->line('customer_name'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="customer_id" name="customer_id" >
                                    </select>
                                    <span id="customer_id_msg" style="display:none" class="text-danger"></span>
                                 </div>

                              </div>
                              
                              <div class="form-group">
                                 <label for="from_date" class="col-sm-2 control-label"><?= $this->lang->line('from_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" value="<?php echo show_date(date('d-m-Y'));?>" >
                                    </div>
                                    <span id="Sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="to_date" class="col-sm-2 control-label"><?= $this->lang->line('to_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" value="<?php echo show_date(date('d-m-Y'))?>" >
                                    </div>
                                    <span id="Sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>

                              <div class="form-group">
                                 <label for="created_by" class="col-sm-2 control-label"><?= $this->lang->line('user'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="created_by" name="created_by">
                                       
                                       <?= get_users_select_list($this->session->userdata("role_id"),get_current_store_id());?>
                                    </select>
                                    <span id="created_by_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>

                           </div>

                           <!-- /.box-body -->
                           <div class="box-footer">
                              <div class="row">
                                 <div class="col-sm-12 text-center">
                                    <div class="btn-group" role="group">
                                       <button type="button" id="view" class="btn btn-success" title="Generate Report">
                                          <i class="fa fa-search"></i> Show Report
                                       </button>
                                       <button type="button" class="btn btn-info no-print" onclick="printPaymentBreakdownReport()" title="Print A4">
                                          <i class="fa fa-print"></i> Print A4
                                       </button>
                                       <button type="button" class="btn btn-primary no-print" onclick="print80mmPaymentBreakdown()" title="Print 80mm Thermal Receipt">
                                          <i class="fa fa-print"></i> Print 80mm Receipt
                                       </button>
                                       <a href="<?=base_url('dashboard');?>" class="btn btn-warning" title="Go Dashboard">
                                          <i class="fa fa-home"></i> Close
                                       </a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           

                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <h3 class="box-title">Payment Method Breakdown</h3>
                           <?php $this->load->view('components/export_btn',array('tableId' => 'report-data'));?>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <table class="table table-bordered table-hover " id="report-data" >
                              <thead>
                                 <tr class="bg-blue">
                                    <th style="width: 10%;">#</th>
                                    <?php if(store_module() && is_admin()){ ?>
                                    <th style="width: 25%;"><?= $this->lang->line('store_name'); ?></th>
                                    <?php } ?>
                                    <th style="width: 30%;">Payment Method</th>
                                    <th style="width: 20%;">Total Amount</th>
                                    <th style="width: 10%;">Transactions</th>
                                    <th style="width: 10%;">Payments</th>
                                    <th style="width: 15%;">Percentage</th>
                                 </tr>
                              </thead>
                              <tbody id="tbodyid">
                              </tbody>
                           </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>
      <!-- TABLE EXPORT CODE -->
      <?php include"comman/code_js_export.php"; ?>
      <script src="<?php echo $theme_link; ?>js/sheetjs.js" type="text/javascript"></script>
      
      <script src="<?php echo $theme_link; ?>js/ajaxselect/customer_select_ajax.js"></script>
      
      <style>
        /* Payment Method Breakdown Report Styling */
        #report-data {
            font-size: 13px;
            margin-top: 15px;
        }
        
        #report-data th {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            text-align: center;
            padding: 12px 8px;
            border: 1px solid #2980b9;
        }
        
        #report-data td {
            padding: 10px 8px;
            vertical-align: middle;
            border: 1px solid #ddd;
        }
        
        #report-data tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        #report-data tr:hover {
            background-color: #e8f4fd;
        }
        
        .payment-method-name {
            font-weight: bold;
            color: #2c3e50;
            font-size: 14px;
        }
        
        .amount-cell {
            font-weight: bold;
            color: #27ae60;
            font-size: 14px;
        }
        
        .percentage-cell {
            font-weight: bold;
            color: #e74c3c;
            font-size: 14px;
        }
        
        .total-row {
            background-color: #e8f4fd !important;
            border-top: 3px solid #3c8dbc !important;
            font-weight: bold;
        }
        
        .total-row td {
            font-size: 15px;
            padding: 12px 8px;
            border-top: 2px solid #3c8dbc !important;
        }
        
        /* Button Group Styling */
        .btn-group .btn {
            margin: 0 2px;
            min-width: 120px;
        }
        
        .btn-group {
            margin: 10px 0;
        }
        
        /* Box Header Styling */
        .box-header {
            border-bottom: 1px solid #f4f4f4;
            padding: 15px;
        }
        
        .box-title {
            font-size: 18px;
            font-weight: bold;
            color: #333;
        }
        
        /* Export Button Positioning */
        .export-btn-container {
            position: absolute;
            top: 15px;
            right: 15px;
        }
      </style>  
      <script type="text/javascript">
         //Customer Selection Box Search
         function getCustomerSelectionId() {
           return '#customer_id';
         }
         //Customer Selection Box Search - END
      </script>
      <script type="text/javascript">
        var base_url=$("#base_url").val();
        
        // Report functionality
        $(document).ready(function(){
            $("#view").click(function(){
                var from_date=$("#from_date").val();
                var to_date=$("#to_date").val();
                var customer_id=$("#customer_id").val();
                var created_by=$("#created_by").val();
                var store_id=$("#store_id").val();
                var warehouse_id=$("#warehouse_id").val();
                
                if(from_date==''){
                    alert("Please select from date");
                    $("#from_date").focus();
                    return false;
                }
                if(to_date==''){
                    alert("Please select to date");
                    $("#to_date").focus();
                    return false;
                }
                
                // Show loading
                $("#tbodyid").html('<tr><td colspan="7" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                
                $.post(base_url+"reports/show_payment_method_breakdown_report",{
                    from_date:from_date,
                    to_date:to_date,
                    customer_id:customer_id,
                    created_by:created_by,
                    store_id:store_id,
                    warehouse_id:warehouse_id,
                    view_all:"no"
                },function(result){
                    $("#tbodyid").html(result);
                }).fail(function(xhr, status, error){
                    console.error('AJAX Error:', error);
                    console.error('Status:', status);
                    console.error('Response:', xhr.responseText);
                    console.error('Status Code:', xhr.status);
                    $("#tbodyid").html('<tr><td colspan="7" class="text-center text-danger">Error loading report. Status: ' + xhr.status + ', Error: ' + error + '</td></tr>');
                });
            });
        });
        
        $("#store_id").on("change",function(){
          var store_id=$(this).val();
          
          autoLoadFirstCustomer();

          $.post(base_url+"sales/get_warehouse_select_list",{store_id:store_id},function(result){
              result='<option value="">All</option>'+result;
              $("#warehouse_id").html('').append(result).select2();
          });

          load_users();

        });

        function load_users(){
         var store_id=$("#store_id").val();
          $.post(base_url+"sales/get_users_select_list",{store_id:store_id},function(result){
             // result='<option value="">All</option>'+result;
              $("#created_by").html('').append(result).select2();
          });
        }

        function print80mmPaymentBreakdown() {
            // Validate report data
            if (!$('#report-data tbody tr').length || $('#report-data tbody tr').first().find('td').text().includes('No Payment Records Found')) {
                alert('Please generate the report first before printing.');
                return;
            }
            
            // Create print window for 80mm thermal printer
            var printWindow = window.open('', '_blank', 'width=400,height=600');
            
            // Get company information
            var companyName = '<?php echo get_store_name(get_current_store_id()); ?>';
            var companyAddress = '<?php echo get_store_details(get_current_store_id())->address ?? ""; ?>';
            var companyPhone = '<?php echo get_store_details(get_current_store_id())->mobile ?? ""; ?>';
            var companyEmail = '<?php echo get_store_details(get_current_store_id())->email ?? ""; ?>';
            
            // Get current date
            var currentDate = new Date().toLocaleDateString();
            
            // Get report period
            var fromDate = $('#from_date').val() || 'All Time';
            var toDate = $('#to_date').val() || 'All Time';
            var reportPeriod = fromDate + ' to ' + toDate;
            
            // Extract payment data from table
            var paymentData = [];
            $('#report-data tbody tr').each(function() {
                var row = $(this);
                var cells = row.find('td');
                if (cells.length >= 6 && !row.text().includes('TOTAL PAYMENTS')) {
                    // Determine column indices based on table structure
                    var hasStoreColumn = <?php echo (store_module() && is_admin()) ? 'true' : 'false'; ?>;
                    var methodIndex = hasStoreColumn ? 2 : 1;
                    var amountIndex = hasStoreColumn ? 3 : 2;
                    var transactionsIndex = hasStoreColumn ? 4 : 3;
                    var paymentsIndex = hasStoreColumn ? 5 : 4;
                    var percentageIndex = hasStoreColumn ? 6 : 5;
                    
                    var method = cells.eq(methodIndex).text().trim();
                    var amount = cells.eq(amountIndex).text().trim();
                    var transactions = cells.eq(transactionsIndex).text().trim();
                    var payments = cells.eq(paymentsIndex).text().trim();
                    var percentage = cells.eq(percentageIndex).text().trim();
                    
                    if (method && method !== '') {
                        paymentData.push({
                            method: method,
                            amount: amount,
                            transactions: transactions,
                            payments: payments,
                            percentage: percentage
                        });
                    }
                }
            });
            
            // Get total amount
            var totalRow = $('#report-data tbody tr').filter(function() {
                return $(this).text().includes('TOTAL PAYMENTS');
            });
            var hasStoreColumn = <?php echo (store_module() && is_admin()) ? 'true' : 'false'; ?>;
            var totalAmountIndex = hasStoreColumn ? 3 : 2;
            var totalAmount = totalRow.length ? totalRow.find('td').eq(totalAmountIndex).text().trim() : '0.00 $';
            
            var printContent = `
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Payment Method Breakdown - 80mm Thermal</title>
                    <style>
                        @page { 
                            margin: 0; 
                            size: 80mm auto; 
                        }
                        body { 
                            font-family: 'Courier New', monospace; 
                            font-size: 10px; 
                            margin: 0; 
                            padding: 0; 
                            width: 80mm;
                            max-width: 80mm;
                            line-height: 1.2;
                        }
                        .receipt-container {
                            width: 80mm;
                            padding: 3mm;
                            box-sizing: border-box;
                        }
                        .receipt-header { 
                            text-align: center; 
                            margin-bottom: 3mm; 
                            border-bottom: 1px dashed #000; 
                            padding-bottom: 2mm; 
                        }
                        .receipt-header h1 { 
                            font-size: 12px; 
                            font-weight: bold; 
                            margin: 0 0 1mm 0; 
                            text-transform: uppercase;
                            letter-spacing: 1px;
                        }
                        .receipt-header .company-info { 
                            font-size: 8px; 
                            margin: 0.5mm 0; 
                            line-height: 1.1;
                        }
                        .receipt-title { 
                            font-size: 10px; 
                            font-weight: bold; 
                            margin: 2mm 0; 
                            text-align: center;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                        }
                        .receipt-period { 
                            font-size: 8px; 
                            margin: 1mm 0; 
                            text-align: center;
                        }
                        .receipt-table { 
                            width: 100%; 
                            border-collapse: collapse; 
                            margin: 2mm 0; 
                            font-size: 9px;
                            table-layout: fixed;
                        }
                        .receipt-table th { 
                            font-weight: bold; 
                            padding: 2mm 1mm; 
                            text-align: center; 
                            border-bottom: 1px solid #000; 
                            font-size: 9px; 
                            background-color: #f0f0f0;
                            vertical-align: middle;
                        }
                        .receipt-table td { 
                            padding: 1mm; 
                            font-size: 9px; 
                            vertical-align: middle; 
                            border-bottom: 1px dotted #ccc;
                            word-wrap: break-word;
                        }
                        .receipt-table .text-right { text-align: right; }
                        .receipt-table .text-center { text-align: center; }
                        .receipt-table .text-left { text-align: left; }
                        .receipt-item {
                            margin: 1mm 0;
                            font-size: 9px;
                            line-height: 1.3;
                        }
                        .receipt-item-header {
                            font-weight: bold;
                            border-bottom: 1px solid #000;
                            padding-bottom: 1mm;
                            margin-bottom: 1mm;
                        }
                        .receipt-item-row {
                            display: flex;
                            justify-content: space-between;
                            margin: 0.5mm 0;
                            font-size: 8px;
                        }
                        .receipt-item-label {
                            flex: 1;
                            text-align: left;
                        }
                        .receipt-item-value {
                            flex: 1;
                            text-align: right;
                            font-weight: bold;
                        }
                        .receipt-column {
                            display: inline-block;
                            vertical-align: top;
                        }
                        .receipt-total { 
                            margin-top: 2mm; 
                            text-align: center; 
                            font-size: 10px; 
                            border-top: 1px dashed #000; 
                            padding-top: 2mm; 
                            font-weight: bold;
                        }
                        .receipt-footer { 
                            margin-top: 3mm; 
                            text-align: center; 
                            font-size: 7px; 
                            border-top: 1px dashed #000; 
                            padding-top: 2mm; 
                            line-height: 1.2;
                        }
                        .receipt-spacer {
                            height: 2mm;
                        }
                        @media print {
                            body { margin: 0; padding: 0; }
                            .receipt-container { padding: 1mm; }
                        }
                    </style>
                </head>
                <body>
                    <div class="receipt-container">
                        <div class="receipt-header">
                            <h1>${companyName}</h1>
                            <div class="company-info">${companyAddress}</div>
                            <div class="company-info">Tel: ${companyPhone}</div>
                            <div class="company-info">${companyEmail}</div>
                        </div>
                        
                        <div class="receipt-title">PAYMENT METHOD BREAKDOWN</div>
                        <div class="receipt-period">Period: ${reportPeriod}</div>
                        <div class="receipt-period">Generated: ${currentDate}</div>
                        
                        <div class="receipt-divider">--------------------------------</div>
                        
                        <table class="receipt-table">
                            <thead>
                                <tr>
                                    <th style="width: 10%;">#</th>
                                    <th style="width: 30%;">Method</th>
                                    <th style="width: 25%;">Amount</th>
                                    <th style="width: 10%;">Txns</th>
                                    <th style="width: 10%;">Pays</th>
                                    <th style="width: 15%;">%</th>
                                </tr>
                            </thead>
                            <tbody>`;
            
            // Add payment data rows in thermal receipt format
            paymentData.forEach(function(payment, index) {
                printContent += `
                            <tr>
                                <td class="text-center">${index + 1}</td>
                                <td class="text-left">${payment.method}</td>
                                <td class="text-right">${payment.amount}</td>
                                <td class="text-center">${payment.transactions}</td>
                                <td class="text-center">${payment.payments}</td>
                                <td class="text-right">${payment.percentage}</td>
                            </tr>`;
            });
            
            printContent += `
                        </tbody>
                    </table>
                    
                    <div class="receipt-divider">--------------------------------</div>
                    
                    <div class="receipt-total">
                        <table style="width: 100%; font-size: 9px;">
                            <tr>
                                <td style="width: 40%; text-align: left;">TOTAL PAYMENTS:</td>
                                <td style="width: 25%; text-align: right;">${totalAmount}</td>
                                <td style="width: 10%; text-align: center;">-</td>
                                <td style="width: 10%; text-align: center;">-</td>
                                <td style="width: 15%; text-align: right;">100.00%</td>
                            </tr>
                        </table>
                    </div>
                    
                    <div class="receipt-spacer"></div>
                    
                    <div class="receipt-footer">
                        <div>Generated: ${currentDate}</div>
                        <div>${companyName} System</div>
                        <div>Contact: ${companyEmail}</div>
                    </div>
                </div>
            </body>
            </html>
        `;
            
            printWindow.document.write(printContent);
            printWindow.document.close();
            printWindow.onload = function() {
                printWindow.focus();
                printWindow.print();
                printWindow.close();
            };
        }

        function printPaymentBreakdownReport() {
            // Validate report data
            if (!$('#report-data tbody tr').length || $('#report-data tbody tr').first().find('td').text().includes('No Payment Records Found')) {
                alert('Please generate the report first before printing.');
                return;
            }
            
            // Create print window
            var printWindow = window.open('', '_blank', 'width=800,height=600');
            
            // Get company information
            var companyName = '<?php echo get_store_name(get_current_store_id()); ?>';
            var companyAddress = '<?php echo get_store_details(get_current_store_id())->address ?? ""; ?>';
            var companyPhone = '<?php echo get_store_details(get_current_store_id())->mobile ?? ""; ?>';
            var companyEmail = '<?php echo get_store_details(get_current_store_id())->email ?? ""; ?>';
            
            // Get current date
            var currentDate = new Date().toLocaleDateString();
            
            // Get report period
            var fromDate = $('#from_date').val() || 'All Time';
            var toDate = $('#to_date').val() || 'All Time';
            var reportPeriod = fromDate + ' to ' + toDate;
            
            // Calculate total columns for colspan
            var totalColumns = 6; // Base columns
            <?php if(store_module() && is_admin()){ ?>
            totalColumns++;
            <?php } ?>
            
            var printContent = `
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Payment Method Breakdown Report - ${companyName}</title>
                    <style>
                      body { 
                        font-family: Arial, sans-serif; 
                        font-size: 12px; 
                        margin: 0; 
                        padding: 20px; 
                        line-height: 1.4;
                      }
                      .print-header { 
                        text-align: center; 
                        margin-bottom: 25px; 
                        border-bottom: 2px solid #333; 
                        padding-bottom: 15px; 
                      }
                      .print-header h1 { 
                        font-size: 22px; 
                        font-weight: bold; 
                        margin: 0 0 8px 0; 
                        color: #333; 
                        text-transform: uppercase;
                        letter-spacing: 1px;
                      }
                      .print-header .company-info { 
                        font-size: 12px; 
                        color: #666; 
                        margin: 3px 0; 
                        line-height: 1.3;
                      }
                      .print-header .report-title { 
                        font-size: 16px; 
                        font-weight: bold; 
                        margin: 12px 0 8px 0; 
                        color: #2c3e50; 
                        text-transform: uppercase;
                        letter-spacing: 0.5px;
                      }
                      .print-header .report-period { 
                        font-size: 11px; 
                        color: #666; 
                        margin: 2px 0; 
                      }
                      .print-table { 
                        width: 100%; 
                        border-collapse: collapse; 
                        margin-top: 15px; 
                        table-layout: fixed;
                      }
                      .print-table th { 
                        background-color: #34495e; 
                        color: white; 
                        font-weight: bold; 
                        padding: 10px 8px; 
                        text-align: center; 
                        border: 1px solid #333; 
                        font-size: 11px; 
                        vertical-align: middle;
                      }
                      .print-table td { 
                        padding: 8px; 
                        border: 1px solid #333; 
                        font-size: 11px; 
                        vertical-align: middle; 
                        word-wrap: break-word;
                      }
                      .print-table tr:nth-child(even) { 
                        background-color: #f8f9fa; 
                      }
                      .print-table .text-right { 
                        text-align: right; 
                      }
                      .print-table .text-center { 
                        text-align: center; 
                      }
                      .print-table .text-left { 
                        text-align: left; 
                      }
                      .print-total-row {
                        background-color: #e8f4fd !important;
                        border-top: 2px solid #34495e !important;
                        font-weight: bold;
                      }
                      .print-total-row td {
                        font-size: 12px;
                        padding: 10px 8px;
                        border-top: 2px solid #34495e !important;
                      }
                      .print-footer { 
                        margin-top: 25px; 
                        text-align: center; 
                        font-size: 10px; 
                        color: #666; 
                        border-top: 1px solid #ccc; 
                        padding-top: 10px; 
                        line-height: 1.4;
                      }
                      @page { 
                        margin: 1.5cm; 
                        size: A4; 
                      }
                      @media print {
                        body { margin: 0; padding: 15px; }
                        .print-table { page-break-inside: avoid; }
                        .print-total-row { page-break-inside: avoid; }
                      }
                    </style>
                </head>
                <body>
                    <div class="print-header">
                        <h1>${companyName}</h1>
                        <div class="company-info">${companyAddress}</div>
                        <div class="company-info">${companyPhone}</div>
                        <div class="company-info">${companyEmail}</div>
                        <div class="report-title">Payment Method Breakdown Report</div>
                        <div class="report-period"><strong>Period:</strong> ${reportPeriod}</div>
                        <div class="report-period"><strong>Generated:</strong> ${currentDate}</div>
                    </div>
                    
                    <table class="print-table">
                        <thead>
                            <tr>
                                <th style="width: 10%;">#</th>
                                <?php if(store_module() && is_admin()){ ?>
                                <th style="width: 25%;">Store Name</th>
                                <?php } ?>
                                <th style="width: 30%;">Payment Method</th>
                                <th style="width: 20%;">Total Amount</th>
                                <th style="width: 10%;">Transactions</th>
                                <th style="width: 10%;">Payments</th>
                                <th style="width: 15%;">Percentage</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${$('#tbodyid').html()}
                        </tbody>
                    </table>
                    
                    <div class="print-footer">
                        <p>This report was generated on ${currentDate} by ${companyName} System</p>
                        <p>For any queries, please contact us at ${companyEmail}</p>
                    </div>
                </body>
                </html>
            `;
            
            printWindow.document.write(printContent);
            printWindow.document.close();
            printWindow.onload = function() {
                printWindow.focus();
                printWindow.print();
                printWindow.close();
            };
        }
      </script>

      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
   </body>
</html>
