<?php
// Get store information for print functions
$store = get_store_details();
$store_name = get_store_name();

// Ensure we have a proper store name
if (empty($store_name) || $store_name === true || $store_name === 1) {
    $store_name = isset($store->store_name) ? $store->store_name : 'NCS Billing Book';
}

$store_address = isset($store->address) ? $store->address : "123 Main Street, New York, NY 10001";
$store_phone = isset($store->mobile) ? "Phone: " . $store->mobile : "Phone: 9999999999";
$store_email = isset($store->email) ? "Email: " . $store->email : "Email: billingbook@email.com";
?>
<!DOCTYPE html>
<html>
   <head>
      <!-- TABLES CSS CODE -->
      <?php include"comman/code_css.php"; ?>
      <!-- </copy> -->  
   </head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li><a href="<?php echo $base_url; ?>purchase"><?= $this->lang->line('purchase_list'); ?></a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">Please Enter Valid Information</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <!-- Store Code -->
                                 <?php if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true')); }else{
                                    echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                                    }?>
                                 <!-- Store Code end -->
                              </div>
                              <div class="form-group">
                                 <!-- Warehouse Code -->
                                     <?php if(true) {
                                       $this->load->view('warehouse/warehouse_code',array('show_warehouse_select_box'=>true,'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true','show_all_option'=>true)); 
                                    }else{
                                     echo "<input type='hidden' name='warehouse_id' id='warehouse_id' value='".get_store_warehouse_id()."'>";
                                     }?>

                                  <!-- Warehouse Code end -->
                                 <label for="supplier_id" class="col-sm-2 control-label"><?= $this->lang->line('supplier_name'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="supplier_id" name="supplier_id" >
                                    </select>
                                    <span id="supplier_id_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              <div class="form-group">
                                 <label for="from_date" class="col-sm-2 control-label"><?= $this->lang->line('from_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" onkeyup="shift_cursor(event,'to_date')" value="<?php echo show_date(date('d-m-Y'));?>">
                                    </div>
                                    <span id="sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="to_date" class="col-sm-2 control-label"><?= $this->lang->line('to_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" onkeyup="shift_cursor(event,'category_name')" value="<?php echo show_date(date('d-m-Y'));?>">
                                    </div>
                                    <span id="sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                               <div class="form-group">
                                 <label for="show_account_payble" class="col-sm-2 control-label"><?= $this->lang->line('view_account_payble'); ?></label>
                                 <div class="col-sm-3">
                                    <input type="checkbox" class="form-control" id="show_account_payble" name="show_account_payble" >
                                    <span id="show_account_payble_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                           </div>
                          
                           <!-- /.box-body -->
                           <div class="box-footer">
                              <div class="col-sm-8 col-sm-offset-2 text-center">
                                 <div class="col-md-2 col-md-offset-2">
                                    <button type="button" id="view" class=" btn btn-block btn-success" title="Save Data">Show</button>
                                 </div>
                                 <div class="col-sm-2">
                                    <button type="button" class="btn btn-block btn-info" onclick="printPurchaseReport()" title="Print Report">
                                       <i class="fa fa-print"></i> Print A4
                                    </button>
                                 </div>
                                 <div class="col-sm-2">
                                    <a href="<?=base_url('dashboard');?>">
                                    <button type="button" class="btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                                    </a>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <h3 class="box-title">Records Table</h3>
                           <?php $this->load->view('components/export_btn',array('tableId' => 'report-data'));?>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <table class="table table-bordered table-hover " id="report-data" >
                              <thead>
                                 <tr class="bg-blue">
                                    <th style="">#</th>
                                    <?php if(store_module() && is_admin()){ ?>
                                    <th style=""><?= $this->lang->line('store_name'); ?></th>
                                    <?php } ?>
                                    <?php if(warehouse_module() && warehouse_count()>0){ ?>
                                      <th style=""><?= $this->lang->line('warehouse_name'); ?></th>
                                    <?php } ?>
                                    <th style=""><?= $this->lang->line('invoice_no'); ?></th>
                                    <th style=""><?= $this->lang->line('purchase_date'); ?></th>
                                    <th style=""><?= $this->lang->line('supplier_id'); ?></th>
                                    <th style=""><?= $this->lang->line('supplier_name'); ?></th>
                                    <th style=""><?= $this->lang->line('invoice_total'); ?>(<?= $CI->currency(); ?>)</th>
                                    <th style=""><?= $this->lang->line('paid_amount'); ?>(<?= $CI->currency(); ?>)</th>
                                    <th style=""><?= $this->lang->line('due_amount'); ?>(<?= $CI->currency(); ?>)</th>
                                 </tr>
                              </thead>
                              <tbody id="tbodyid">
                              </tbody>
                           </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>

<!-- Print-specific CSS -->
<style>
@media print {
    body {
        margin: 0;
        padding: 20px;
        font-family: Arial, sans-serif;
        font-size: 12px;
        line-height: 1.4;
        color: #000;
        background: white;
    }
    
    .no-print {
        display: none !important;
    }
    
    .print-header {
        text-align: center;
        margin-bottom: 30px;
        border-bottom: 2px solid #333;
        padding-bottom: 20px;
    }
    
    .print-header h1 {
        font-size: 24px;
        font-weight: bold;
        margin: 0 0 10px 0;
        color: #333;
    }
    
    .print-header .company-info {
        font-size: 14px;
        color: #666;
        margin: 5px 0;
    }
    
    .print-header .report-title {
        font-size: 18px;
        font-weight: bold;
        margin: 15px 0 10px 0;
        color: #2c3e50;
    }
    
    .print-header .report-filters {
        font-size: 12px;
        color: #666;
        margin: 5px 0;
    }
    
    .print-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    
    .print-table th {
        background-color: #34495e !important;
        color: white !important;
        font-weight: bold;
        padding: 8px 6px;
        text-align: center;
        border: 1px solid #333;
        font-size: 11px;
    }
    
    .print-table td {
        padding: 6px;
        border: 1px solid #333;
        font-size: 11px;
        vertical-align: top;
    }
    
    .print-table tr:nth-child(even) {
        background-color: #f8f9fa;
    }
    
    .print-table .text-right {
        text-align: right;
    }
    
    .print-table .text-center {
        text-align: center;
    }
    
    .print-table .text-left {
        text-align: left;
    }
    
    .print-footer {
        margin-top: 30px;
        text-align: center;
        font-size: 10px;
        color: #666;
        border-top: 1px solid #ccc;
        padding-top: 10px;
    }
    
    .page-break {
        page-break-before: always;
    }
    
    @page {
        margin: 1cm;
        size: A4;
    }
}
</style>

      <!-- TABLE EXPORT CODE -->
      <?php include"comman/code_js_export.php"; ?>
      <script src="<?php echo $theme_link; ?>js/sheetjs.js" type="text/javascript"></script>
      
      <script src="<?php echo $theme_link; ?>js/report-purchase.js"></script>
      <script src="<?php echo $theme_link; ?>js/ajaxselect/supplier_select_ajax.js"></script>  
      <script>
         //Customer Selection Box Search
         function getsupplierSelectionId() {
           return '#supplier_id';
         }
         //Customer Selection Box Search - END
      </script>

      <script type="text/javascript">
         var base_url=$("#base_url").val();
         
         // Professional A4 Print Function for Purchase Report
         function printPurchaseReport() {
             // Check if report data exists
             if (!$('#tbodyid').html() || $('#tbodyid').html().trim() === '') {
                 alert('Please generate the purchase report first before printing.');
                 return;
             }
             
             // Create print window
             var printWindow = window.open('', '_blank', 'width=800,height=600');
             
             // Get company information dynamically
             var companyName = '<?php echo $store_name ? $store_name : "NCS Billing Book"; ?>';
             var companyAddress = '<?php echo $store_address; ?>';
             var companyPhone = '<?php echo $store_phone; ?>';
             var companyEmail = '<?php echo $store_email; ?>';
             
             // Get current date
             var currentDate = new Date().toLocaleDateString();
             
             // Get report filters
             var storeName = $('#store_id option:selected').text() || 'All Stores';
             var warehouseName = $('#warehouse_id option:selected').text() || 'All Warehouses';
             var supplierName = $('#supplier_id option:selected').text() || 'All Suppliers';
             var fromDate = $('#from_date').val() || 'All Time';
             var toDate = $('#to_date').val() || 'All Time';
             var showAccountPayable = $('#show_account_payble').is(':checked') ? 'Yes' : 'No';
             
             // Get table data
             var tableHeaders = $('#report-data thead').html();
             var tableData = $('#tbodyid').html();
             
             // Build print content
             var printContent = `
                 <!DOCTYPE html>
                 <html>
                 <head>
                     <title>Purchase Report</title>
                     <style>
                         body { font-family: Arial, sans-serif; font-size: 12px; margin: 0; padding: 20px; }
                         .print-header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
                         .print-header h1 { font-size: 24px; font-weight: bold; margin: 0 0 10px 0; color: #333; }
                         .print-header .company-info { font-size: 14px; color: #666; margin: 5px 0; }
                         .print-header .report-title { font-size: 18px; font-weight: bold; margin: 15px 0 10px 0; color: #2c3e50; }
                         .print-header .report-filters { font-size: 12px; color: #666; margin: 5px 0; }
                         .print-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                         .print-table th { background-color: #34495e; color: white; font-weight: bold; padding: 8px 6px; text-align: center; border: 1px solid #333; font-size: 11px; }
                         .print-table td { padding: 6px; border: 1px solid #333; font-size: 11px; vertical-align: top; }
                         .print-table tr:nth-child(even) { background-color: #f8f9fa; }
                         .print-table .text-right { text-align: right; }
                         .print-table .text-center { text-align: center; }
                         .print-table .text-left { text-align: left; }
                         .print-footer { margin-top: 30px; text-align: center; font-size: 10px; color: #666; border-top: 1px solid #ccc; padding-top: 10px; }
                         @page { margin: 1cm; size: A4; }
                     </style>
                 </head>
                 <body>
                     <div class="print-header">
                         <h1>${companyName}</h1>
                         <div class="company-info">${companyAddress}</div>
                         <div class="company-info">${companyPhone}</div>
                         <div class="company-info">${companyEmail}</div>
                         <div class="report-title">Purchase Report</div>
                         <div class="report-filters"><strong>Store:</strong> ${storeName}</div>
                         <div class="report-filters"><strong>Warehouse:</strong> ${warehouseName}</div>
                         <div class="report-filters"><strong>Supplier:</strong> ${supplierName}</div>
                         <div class="report-filters"><strong>Period:</strong> ${fromDate} to ${toDate}</div>
                         <div class="report-filters"><strong>Show Account Payable Only:</strong> ${showAccountPayable}</div>
                         <div class="report-filters"><strong>Generated:</strong> ${currentDate}</div>
                     </div>
                     
                     <table class="print-table">
                         <thead>
                             ${tableHeaders}
                         </thead>
                         <tbody>
                             ${tableData}
                         </tbody>
                     </table>
                     
                     <div class="print-footer">
                         <p>This report was generated on ${currentDate} by ${companyName} System</p>
                         <p>For any queries, please contact us at ${companyEmail}</p>
                     </div>
                 </body>
                 </html>
             `;
             
             // Write content and print
             printWindow.document.write(printContent);
             printWindow.document.close();
             
             // Wait for content to load, then print
             printWindow.onload = function() {
                 printWindow.focus();
                 printWindow.print();
                 printWindow.close();
             };
         }
         
         $("#store_id").on("change",function(){
           var store_id=$(this).val();
           
           autoLoadFirstsupplier();

           $.post(base_url+"sales/get_warehouse_select_list",{store_id:store_id},function(result){
              result='<option value="">All</option>'+result;
              $("#warehouse_id").html('').append(result).select2();
          });
         });
      </script>
      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
   </body>
</html>
