<!DOCTYPE html>
<html>
   <head>
      <!-- TABLES CSS CODE -->
      <?php include"comman/code_css.php"; ?>
      
      <!-- A4 Print Styles -->
      <style>
        @media print {
            .no-print { display: none !important; }
            .print-break { page-break-before: always; }
            body { 
                font-size: 12px; 
                margin: 0; 
                padding: 0; 
                background: white !important;
            }
            .report-container { 
                margin: 0; 
                padding: 20px; 
                box-shadow: none;
                border: none;
            }
            .company-header {
                margin-bottom: 20px;
                padding-bottom: 15px;
                border-bottom: 2px solid #000;
            }
            .company-name {
                font-size: 20px;
                margin: 10px 0;
            }
            .company-details {
                font-size: 12px;
            }
            .report-title {
                font-size: 18px;
                margin: 15px 0;
            }
            .report-period {
                font-size: 14px;
                margin-bottom: 20px;
            }
            .table {
                font-size: 11px;
                border-collapse: collapse;
            }
            .table th,
            .table td {
                border: 1px solid #000;
                padding: 4px 8px;
                text-align: left;
            }
            .table th {
                background-color: #f0f0f0;
                font-weight: bold;
            }
            .text-right {
                text-align: right !important;
            }
        }
      </style>  
   </head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">Please Enter Valid Information</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <!-- Store Code -->
                                 <?php if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true')); }else{
                                    echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                                    }?>
                                 <!-- Store Code end -->

                              </div>
                              <div class="form-group">
                                 <!-- Warehouse Code -->
                                 <?php 
                                 
                                  if(true) {$this->load->view('warehouse/warehouse_code',array('show_warehouse_select_box'=>true,'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true','show_all_option'=>true)); }else{
                                     echo "<input type='hidden' name='warehouse_id' id='warehouse_id' value='".get_store_warehouse_id()."'>";
                                  }
                                 ?>
                                 <!-- Warehouse Code end -->

                                 <label for="item_id" class="col-sm-2 control-label"><?= $this->lang->line('item_type'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="item_type" name="item_type" >
                                       <option value="">-All-</option>
                                       <option value="Items">Items</option>
                                       <option value="Services">Services</option>
                                       
                                    </select>
                                    <span id="item_id_msg" style="display:none" class="text-danger"></span>
                                 </div>

                              </div>
                              <div class="form-group">
                                 <label for="category_id" class="col-sm-2 control-label"><?= $this->lang->line('category'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="category_id" name="category_id" >
                                       <option value="">-All-</option>
                                       <?= get_categories_select_list(null,get_current_store_id());?>
                                    </select>
                                    <span id="category_id_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="item_id" class="col-sm-2 control-label"><?= $this->lang->line('item_name'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="item_id" name="item_id" >
                                    </select>
                                    <span id="item_id_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              <div class="form-group">
                                 <label for="from_date" class="col-sm-2 control-label"><?= $this->lang->line('from_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" value="<?php echo show_date(date('d-m-Y'));?>" >
                                    </div>
                                    <span id="Sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="to_date" class="col-sm-2 control-label"><?= $this->lang->line('to_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" value="<?php echo show_date(date('d-m-Y'))?>" >
                                    </div>
                                    <span id="Sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-body -->
                           <div class="box-footer">
                              <div class="col-sm-8 col-sm-offset-2 text-center">
                                 <div class="col-md-3 col-md-offset-3">
                                    <button type="button" id="view" class=" btn btn-block btn-success" title="Save Data">Show</button>
                                 </div>
                                 <div class="col-sm-3">
                                    <button type="button" class="btn btn-block btn-info no-print" onclick="printSalesSummaryReport()" title="Print A4">
                                       <i class="fa fa-print"></i> Print A4
                                    </button>
                                 </div>
                                 <div class="col-sm-3">
                                    <a href="<?=base_url('dashboard');?>">
                                    <button type="button" class="col-sm-3 btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                                    </a>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <h3 class="box-title"><?= $this->lang->line('records_table'); ?></h3>
                           <div class="box-tools pull-right">
                              <?php $this->load->view('components/export_btn',array('tableId' => 'report-data'));?>
                           </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <table class="table table-bordered table-hover " id="report-data" >
                              <thead>
                                 <tr class="bg-blue">
                                    <th style="">#</th>
                                    <?php if(store_module() && is_admin()){ ?>
                                    <th style=""><?= $this->lang->line('store_name'); ?></th>
                                    <?php } ?>
                                    
                                    <th style=""><?= $this->lang->line('item_name'); ?></th>
                                    <th style=""><?= $this->lang->line('category'); ?></th>
                                    <th style="text-align: right;"><?= $this->lang->line('quantity'); ?></th>
                                    <th style="text-align: right;">Total Sales (Base)</th>
                                    <th style="text-align: right;">Total Revenue (Base)</th>
                                    
                                 </tr>
                              </thead>
                              <tbody id="tbodyid">
                              </tbody>
                           </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>
      <!-- TABLE EXPORT CODE -->
      <?php include"comman/code_js_export.php"; ?>
      <script src="<?php echo $theme_link; ?>js/sheetjs.js" type="text/javascript"></script>

      <script src="<?php echo $theme_link; ?>js/ajaxselect/item_select_ajax.js"></script>  
      <script>
         //Item Selection Box Search
         function getItemSelectionId() {
           return '#item_id';
         }
         //Item Selection Box Search - END
      </script>

      
      <script type="text/javascript">
         var base_url=$("#base_url").val();
         $("#store_id").on("change",function(){
           var store_id=$(this).val();
           //Load Items
           autoLoadFirstItem();

           //Load Categories
           load_category_list();

           //Ajax to load warehouses
           $.post(base_url+"sales/get_warehouse_select_list",{store_id:store_id},function(result){
              result='<option value="">All</option>'+result;
              $("#warehouse_id").html('').append(result).select2();
          });
         });

         $("#category_id, #item_type").on("change",function(){
            autoLoadFirstItem();
         });

         //Ajax to load categories
         function load_category_list(){
           var store_id=$("#store_id").val();
           $.post(base_url+"sales/get_categories_select_list",{store_id:store_id},function(result){
                result='<option value="">All</option>'+result;
                $("#category_id").html('').append(result).select2();
            });
          }
      </script>
      <script type="text/javascript">
         function load_records(){

            $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');


            data = new FormData($('#report-form')[0]);//form name
        /*Check XSS Code*/
        if(!xss_validation(data)){ return false; }
        
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $("#view").attr('disabled',true);  //Enable Save or Update button
            $.ajax({
            type: 'POST',
            url: base_url+'reports/show_sales_summary_report',
            data: data,
            cache: false,
            contentType: false,
            processData: false,
            success: function(result){

               $("#tbodyid").empty().append(result);     
            
               $("#view").attr('disabled',false);  //Enable Save or Update button
               $(".overlay").remove();

            }
            });
            
         }


$("#view").on("click",function(){
      check_field("from_date");
      check_field("to_date");

      load_records();
      
});


function check_field(id)
    {

      if(!$("#"+id).val() ) //Also check Others????
        {

            $('#'+id+'_msg').fadeIn(200).show().html('Required Field').addClass('required');
           // $('#'+id).css({'background-color' : '#E8E2E9'});
            flag=false;
        }
        else
        {
             $('#'+id+'_msg').fadeOut(200).hide();
             //$('#'+id).css({'background-color' : '#FFFFFF'});    //White color
        }
    }

      </script>
      
      <!-- A4 Print Function -->
      <script>
      function printSalesSummaryReport() {
          // Validate report data
          if (!$('#report-data tbody tr').length || $('#report-data tbody tr').first().find('td').text().includes('No Records Found')) {
              alert('Please generate the report first before printing.');
              return;
          }
          
          // Create print window
          var printWindow = window.open('', '_blank', 'width=800,height=600');
          
          // Get company information
          var companyName = '<?php echo get_store_name(get_current_store_id()); ?>';
          var companyAddress = '<?php echo get_store_details(get_current_store_id())->address ?? ""; ?>';
          var companyPhone = '<?php echo get_store_details(get_current_store_id())->mobile ?? ""; ?>';
          var companyEmail = '<?php echo get_store_details(get_current_store_id())->email ?? ""; ?>';
          
          // Get current date
          var currentDate = new Date().toLocaleDateString();
          
          // Get report period
          var fromDate = $('#from_date').val() || 'All Time';
          var toDate = $('#to_date').val() || 'All Time';
          var reportPeriod = fromDate + ' to ' + toDate;
          
          // Build print content
          var printContent = `
              <!DOCTYPE html>
              <html>
              <head>
                  <title>Sales Summary Report - ${companyName}</title>
                  <style>
                      body { font-family: Arial, sans-serif; font-size: 12px; margin: 0; padding: 30px 20px; }
                      .print-header { text-align: center; margin-bottom: 30px; margin-top: 20px; border-bottom: 2px solid #333; padding-bottom: 20px; }
                      .print-header h1 { font-size: 24px; font-weight: bold; margin: 0 0 10px 0; color: #333; }
                      .print-header .company-info { font-size: 14px; color: #666; margin: 5px 0; }
                      .print-header .report-title { font-size: 18px; font-weight: bold; margin: 15px 0 10px 0; color: #2c3e50; }
                      .print-header .report-period { font-size: 12px; color: #666; margin: 5px 0; }
                      .print-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                      .print-table th { background-color: #34495e; color: white; font-weight: bold; padding: 8px 6px; text-align: center; border: 1px solid #333; font-size: 11px; }
                      .print-table td { padding: 6px; border: 1px solid #333; font-size: 11px; vertical-align: top; }
                      .print-table tr:nth-child(even) { background-color: #f8f9fa; }
                      .print-table .text-right { text-align: right; }
                      .print-table .text-center { text-align: center; }
                      .print-table .text-left { text-align: left; }
                      .print-footer { margin-top: 30px; text-align: center; font-size: 10px; color: #666; border-top: 1px solid #ccc; padding-top: 10px; }
                      @page { margin: 1cm; size: A4; }
                  </style>
              </head>
              <body>
                  <div class="print-header">
                      <h1>${companyName}</h1>
                      <div class="company-info">${companyAddress}</div>
                      <div class="company-info">${companyPhone}</div>
                      <div class="company-info">${companyEmail}</div>
                      <div class="report-title">Sales Summary Report</div>
                      <div class="report-period"><strong>Period:</strong> ${reportPeriod}</div>
                      <div class="report-period"><strong>Generated:</strong> ${currentDate}</div>
                  </div>
                  
                  <table class="print-table">
                      <thead>
                          <tr>
                              <th>#</th>
                              <?php if(store_module() && is_admin()){ ?>
                              <th>Store Name</th>
                              <?php } ?>
                              <th>Item Name</th>
                              <th>Category</th>
                              <th>Quantity</th>
                               <th>Total Sales (Base)</th>
                               <th>Total Revenue (Base)</th>
                          </tr>
                      </thead>
                      <tbody>
                          ${$('#tbodyid').html()}
                      </tbody>
                  </table>
                  
                  <div class="print-footer">
                      <p>This report was generated on ${currentDate} by ${companyName} System</p>
                      <p>For any queries, please contact us at ${companyEmail}</p>
                  </div>
              </body>
              </html>
          `;
          
          // Write content and print
          printWindow.document.write(printContent);
          printWindow.document.close();
          
          // Wait for content to load, then print
          printWindow.onload = function() {
              printWindow.focus();
              printWindow.print();
              printWindow.close();
          };
      }
      </script>
      
      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
   </body>
</html>