<!DOCTYPE html>
<html>
<head>
<!-- FORM CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- </copy> -->  
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

 <?php include"sidebar.php"; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
       <?= $this->lang->line('send_bulk_sms'); ?>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="<?php echo $base_url; ?>sms_promotional">Promotional SMS</a></li>
        <li class="active"><?= $this->lang->line('send_bulk_sms'); ?></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <!-- right column -->
        <div class="col-md-12">
          <!-- Horizontal Form -->
          <div class="col-md-8">
         <div class="box box-primary">
           
            <!-- /.box-header -->
            <!-- form start -->
            <form role="form" id="bulk-sms-form" onkeypress="return event.keyCode != 13;">
              <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
              <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
              <input type="hidden" name="send_type" value="bulk">
              <div class="box-body">
                
                <!-- Customer Selection -->
                <div class="form-group">
                  <label for="customer_ids"><?= $this->lang->line('select_customers'); ?> <span class="text-danger">*</span></label>
                  <select class="form-control" id="customer_ids" name="customer_ids" multiple onchange="updateSelectedCount()">
                    <?php foreach($customers as $customer): ?>
                    <option value="<?= $customer->id ?>"><?= $customer->customer_name ?> (<?= $customer->mobile ?>)</option>
                    <?php endforeach; ?>
                  </select>
                  <small class="text-muted">Hold Ctrl/Cmd to select multiple customers</small>
                  <span id="customer_ids_msg" style="display:none" class="text-danger"></span>
                </div>

                <!-- Quick Selection Buttons -->
                <div class="form-group">
                  <label>Quick Selection:</label>
                  <div class="btn-group" role="group">
                    <button type="button" class="btn btn-sm btn-info" onclick="selectAllCustomers()">Select All</button>
                    <button type="button" class="btn btn-sm btn-warning" onclick="clearAllCustomers()">Clear All</button>
                    <button type="button" class="btn btn-sm btn-success" onclick="selectActiveCustomers()">Active Only</button>
                  </div>
                  <div class="text-muted">
                    <span id="selected_count">0 customers selected</span>
                  </div>
                </div>

                <!-- Selected Customers Display -->
                <div class="form-group" id="selected_customers_div" style="display:none;">
                  <label>Selected Customers:</label>
                  <div class="well" id="selected_customers_list">
                    <!-- Selected customers will be shown here -->
                  </div>
                </div>

                <!-- Template Selection -->
                <div class="form-group">
                  <label for="template_id"><?= $this->lang->line('select_template'); ?> (Optional)</label>
                  <div class="input-group">
                    <select class="form-control" id="template_id" name="template_id" onchange="loadTemplate()">
                      <option value="">Select Template (Optional)</option>
                      <?php foreach($templates as $template): ?>
                      <option value="<?= $template->id ?>"><?= $template->template_name ?></option>
                      <?php endforeach; ?>
                    </select>
                    <span class="input-group-btn">
                      <a href="<?= base_url('templates/sms_new') ?>" class="btn btn-info" target="_blank" title="Create New Template">
                        <i class="fa fa-plus"></i> New Template
                      </a>
                    </span>
                  </div>
                  <small class="text-muted">Don't see the template you need? <a href="<?= base_url('templates/sms') ?>" target="_blank">Manage Templates</a></small>
                </div>

                <!-- Message Input -->
                <div class="form-group">
                  <label for="message"><?= $this->lang->line('message'); ?> <span class="text-danger">*</span></label>
                  <textarea class="form-control" id="message" name="message" rows="5" placeholder="Hi {{customer_name}}, 

We have exciting news! 🎉

Visit our store {{store_name}} today and get amazing discounts!

📍 {{store_address}}
📞 {{store_mobile}}
🌐 {{store_website}}

Valid until {{current_date}}

Thank you for choosing us!"></textarea>
                  <div class="help-block">
                    <strong>Available Variables:</strong><br>
                    <code>{{customer_name}}</code> - Customer's name<br>
                    <code>{{customer_mobile}}</code> - Customer's mobile<br>
                    <code>{{store_name}}</code> - Your store name<br>
                    <code>{{store_mobile}}</code> - Store contact number<br>
                    <code>{{store_address}}</code> - Store address<br>
                    <code>{{store_website}}</code> - Store website<br>
                    <code>{{current_date}}</code> - Today's date<br>
                    <code>{{current_time}}</code> - Current time
                  </div>
                  <span id="message_msg" style="display:none" class="text-danger"></span>
                </div>

                <!-- Preview Section -->
                <div class="form-group" id="preview_div" style="display:none;">
                  <label><?= $this->lang->line('message_preview'); ?></label>
                  <div class="well" id="message_preview">
                    <!-- Preview will be shown here -->
                  </div>
                </div>
              
              </div>
              <!-- /.box-body -->

              <div class="box-footer"> 
              <div class="col-md-3 col-md-offset-3">
                      <button type="button" id="send" class=" btn btn-block btn-success" title="Send SMS">Send SMS</button>
                   </div>
                <div class="col-sm-3">
                    <a href="<?=base_url('sms_promotional');?>">
                      <button type="button" class="col-sm-3 btn btn-block btn-warning close_btn" title="Go Back">Back</button>
                    </a>
                   </div>

              </div>
            </form>
          </div>
          <!-- /.box -->
        </div>

        <!-- Statistics Panel -->
        <div class="col-md-4">
          <div class="box box-success">
            <div class="box-header with-border">
              <h3 class="box-title">Customer Statistics</h3>
            </div>
            <div class="box-body">
              <p><strong>Total Customers:</strong> <span id="total_customers"><?= count($customers) ?></span></p>
              <p><strong>Selected:</strong> <span id="selected_customers_count">0</span></p>
              <p><strong>Available Templates:</strong> <?= count($templates) ?></p>
            </div>
          </div>

          <div class="box box-info">
            <div class="box-header with-border">
              <h3 class="box-title">Bulk SMS Tips</h3>
            </div>
            <div class="box-body">
              <ul>
                <li>Test with a small group first</li>
                <li>Use templates for consistency</li>
                <li>Check message length limits</li>
                <li>Consider sending time</li>
                <li>Monitor delivery rates</li>
              </ul>
            </div>
          </div>
        </div>

        </div>
        <!--/.col (right) -->
      </div>
      <!-- /.row -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

 <?php include"footer.php"; ?>

  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>

<script src="<?php echo $theme_link; ?>js/sms-promotional.js"></script>
<!-- Make sidebar menu hughlighter/selector -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>

</body>
</html>
