<!DOCTYPE html>
<html>
<head>
<!-- FORM CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- </copy> -->  
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

 <?php include"sidebar.php"; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
       <?= $this->lang->line('promotional_sms'); ?>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><?= $this->lang->line('promotional_sms'); ?></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <!-- right column -->
        <div class="col-md-12">
          <!-- Horizontal Form -->
          <div class="col-md-8">
         <div class="box box-primary">
           
            <!-- /.box-header -->
            <!-- form start -->
            <form role="form" id="promotional-sms-form" onkeypress="return event.keyCode != 13;">
              <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
              <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
              <div class="box-body">
                
                <!-- Send Type Selection -->
                <div class="form-group">
                  <label for="send_type"><?= $this->lang->line('send_type'); ?> <span class="text-danger">*</span></label>
                  <select class="form-control" id="send_type" name="send_type" onchange="toggleSendTypeOptions()">
                    <option value="">Select Send Type</option>
                    <option value="single">Single Customer</option>
                    <option value="bulk">Multiple Customers</option>
                    <option value="all">All Customers</option>
                  </select>
                  <span id="send_type_msg" style="display:none" class="text-danger"></span>
                </div>

                <!-- Single Customer Selection -->
                <div class="form-group" id="single_customer_div" style="display:none;">
                  <label for="customer_id"><?= $this->lang->line('select_customer'); ?> <span class="text-danger">*</span></label>
                  <select class="form-control" id="customer_id" name="customer_id">
                    <option value="">Select Customer</option>
                    <?php foreach($customers as $customer): ?>
                    <option value="<?= $customer->id ?>"><?= $customer->customer_name ?> (<?= $customer->mobile ?>)</option>
                    <?php endforeach; ?>
                  </select>
                  <span id="customer_id_msg" style="display:none" class="text-danger"></span>
                </div>

                <!-- Multiple Customers Selection -->
                <div class="form-group" id="bulk_customers_div" style="display:none;">
                  <label for="customer_ids"><?= $this->lang->line('select_customers'); ?> <span class="text-danger">*</span></label>
                  <select class="form-control" id="customer_ids" name="customer_ids" multiple>
                    <?php foreach($customers as $customer): ?>
                    <option value="<?= $customer->id ?>"><?= $customer->customer_name ?> (<?= $customer->mobile ?>)</option>
                    <?php endforeach; ?>
                  </select>
                  <small class="text-muted">Hold Ctrl/Cmd to select multiple customers</small>
                  <span id="customer_ids_msg" style="display:none" class="text-danger"></span>
                </div>

                <!-- All Customers Info -->
                <div class="form-group" id="all_customers_div" style="display:none;">
                  <div class="alert alert-info">
                    <i class="fa fa-info-circle"></i> SMS will be sent to all customers who have mobile numbers registered.
                  </div>
                </div>

                <!-- Template Selection -->
                <div class="form-group">
                  <label for="template_id"><?= $this->lang->line('select_template'); ?> (Optional)</label>
                  <select class="form-control" id="template_id" name="template_id" onchange="loadTemplate()">
                    <option value="">Select Template (Optional)</option>
                    <?php foreach($templates as $template): ?>
                    <option value="<?= $template->id ?>"><?= $template->template_name ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>

                <!-- Message Input -->
                <div class="form-group">
                  <label for="message"><?= $this->lang->line('message'); ?> <span class="text-danger">*</span></label>
                  <textarea class="form-control" id="message" name="message" rows="5" placeholder="Enter your promotional message here..."></textarea>
                  <small class="text-muted">Available variables: {{customer_name}}, {{customer_mobile}}, {{store_name}}, {{store_mobile}}, {{store_address}}, {{current_date}}, {{current_time}}</small>
                  <span id="message_msg" style="display:none" class="text-danger"></span>
                </div>

                <!-- Preview Section -->
                <div class="form-group" id="preview_div" style="display:none;">
                  <label><?= $this->lang->line('message_preview'); ?></label>
                  <div class="well" id="message_preview">
                    <!-- Preview will be shown here -->
                  </div>
                </div>
              
              </div>
              <!-- /.box-body -->

              <div class="box-footer"> 
              <div class="col-md-3 col-md-offset-3">
                      <button type="button" id="send" class=" btn btn-block btn-success" title="Send SMS">Send SMS</button>
                   </div>
                <div class="col-sm-3">
                    <a href="<?=base_url('dashboard');?>">
                      <button type="button" class="col-sm-3 btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                    </a>
                   </div>

              </div>
            </form>
          </div>
          <!-- /.box -->
        </div>

        <!-- Quick Actions Panel -->
        <div class="col-md-4">
          <div class="box box-info">
            <div class="box-header with-border">
              <h3 class="box-title">Quick Actions</h3>
            </div>
            <div class="box-body">
              <div class="list-group">
                <a href="<?= base_url('sms_promotional/send_single') ?>" class="list-group-item">
                  <i class="fa fa-user"></i> Send to Single Customer
                </a>
                <a href="<?= base_url('sms_promotional/send_bulk') ?>" class="list-group-item">
                  <i class="fa fa-users"></i> Send to Multiple Customers
                </a>
                <a href="<?= base_url('sms_promotional/history') ?>" class="list-group-item">
                  <i class="fa fa-history"></i> View SMS History
                </a>
                <a href="<?= base_url('templates/sms') ?>" class="list-group-item">
                  <i class="fa fa-file-text"></i> Manage Templates
                </a>
              </div>
            </div>
          </div>

          <!-- Customer Stats -->
          <div class="box box-success">
            <div class="box-header with-border">
              <h3 class="box-title">Customer Statistics</h3>
            </div>
            <div class="box-body">
              <p><strong>Total Customers:</strong> <?= count($customers) ?></p>
              <p><strong>With Mobile Numbers:</strong> <?= count($customers) ?></p>
              <p><strong>Available Templates:</strong> <?= count($templates) ?></p>
            </div>
          </div>
        </div>

        </div>
        <!--/.col (right) -->
      </div>
      <!-- /.row -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

 <?php include"footer.php"; ?>

  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>

<script src="<?php echo $theme_link; ?>js/sms-promotional.js"></script>
<!-- Make sidebar menu hughlighter/selector -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>

</body>
</html>
